package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView
import app.appnomix.sdk.internal.domain.CouponCodeApplier
import app.appnomix.sdk.internal.domain.model.Coupon
import kotlinx.coroutines.delay

data object ApplyBestCouponCodeNode : TreeNode() {

    override suspend fun execute() {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        val couponsToVerify =
            inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST) ?: listOf()
        val bestCouponIndex =
            inventory?.get<Int>(TreeInventoryType.BEST_COUPON_INDEX_DETECTED) ?: -1
        if (config != null && webView != null && bestCouponIndex >= 0) {
            val coupon = couponsToVerify[bestCouponIndex]

            InsertCouponCodeExecutor.execute(
                inputJsSelector = config.selectorCouponInput ?: "",
                code = coupon.code,
                webView = webView
            )

            ApplyCouponButtonExecutor.execute(
                selector = config.selectorCouponApplyButton ?: "",
                reloadOnApply = config.reloadOnApply == true,
                webView = webView
            )

            config.delayAfterCouponMs?.let { delay(it.toLong()) }

            val externalCouponCodeApplier =
                inventory?.get<CouponCodeApplier>(TreeInventoryType.EXTERNAL_COUPON_CODE_APPLIER)
            externalCouponCodeApplier?.apply(coupon.code)

            markReadyForTransition(TreeTransition.Positive)
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }

    override fun positiveChildNode(): TreeNode = TerminalNode
}
