package app.appnomix.sdk.internal.domain.machine.states

import app.appnomix.sdk.internal.Deps
import app.appnomix.sdk.internal.domain.CouponsRepo
import kotlinx.coroutines.sync.Mutex

data object AutoApplyConfigProvisionNode : TreeNode() {
    private val repo: CouponsRepo by lazy { Deps.repo() }

    override suspend fun execute() {
        inventory?.get<String>(TreeInventoryType.CURRENT_URL)?.let { url ->
            repo.getCheckoutConfig(url)?.let { data ->
                inventory?.save(TreeInventoryType.CHECKOUT_CONFIG, data.checkoutConfig)
                inventory?.save(TreeInventoryType.COUPON_LIST, data.coupons)

                markReadyForTransition(TreeTransition.Positive)
            } ?: markReadyForTransition(TreeTransition.Negative)
        }
    }

    override fun positiveChildNode() = AutoApplyDataVerifierNode
}
