package app.appnomix.sdk.internal.domain.model

import app.appnomix.sdk.internal.data.local.model.DemandInteractionEntity
import java.time.LocalDateTime


data class Demand(
    val redirectUrl: String,
    val rootDomain: String,
    val countryCode: String?,
    val brandImageUrl: String?,
    val snoozeTime: LocalDateTime?,
    val lastUseTime: LocalDateTime?,
    val snoozeCount: Int,
) {
    private val regex: Regex by lazy {
        Regex(
            pattern = "^(?:https?://(?:www\\.)?)?(.*\\.)*$rootDomain.*",
            options = setOf(RegexOption.IGNORE_CASE)
        )
    }

    fun matchesTarget(address: String): Boolean {
        return regex.matches(address)
    }
}

fun Demand.toDemandInteractionEntity(
    snoozeCount: Int = this.snoozeCount,
    snoozeTime: LocalDateTime? = this.snoozeTime,
    lastUseTime: LocalDateTime? = this.lastUseTime,
): DemandInteractionEntity {
    return DemandInteractionEntity(
        brandDomain = rootDomain,
        snoozeTime = snoozeTime,
        snoozeCount = snoozeCount,
        lastUseTime = lastUseTime,
    )
}