/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "organization_guid", "name", "type", "supported_trading_symbols", "supported_fiat_account_assets", "supported_country_codes", "features", "routable_accounts", "created_at"})
@JsonTypeName(value="Bank")
public class BankBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_ORGANIZATION_GUID = "organization_guid";
    private String organizationGuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SUPPORTED_TRADING_SYMBOLS = "supported_trading_symbols";
    private List<String> supportedTradingSymbols = null;
    public static final String JSON_PROPERTY_SUPPORTED_FIAT_ACCOUNT_ASSETS = "supported_fiat_account_assets";
    private List<String> supportedFiatAccountAssets = null;
    public static final String JSON_PROPERTY_SUPPORTED_COUNTRY_CODES = "supported_country_codes";
    private List<String> supportedCountryCodes = null;
    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<FeaturesEnum> features = new ArrayList<FeaturesEnum>();
    public static final String JSON_PROPERTY_ROUTABLE_ACCOUNTS = "routable_accounts";
    private RoutableAccountsEnum routableAccounts;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;

    public BankBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Auto-generated unique identifier for the bank.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public BankBankModel organizationGuid(String organizationGuid) {
        this.organizationGuid = organizationGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The organization's identifier.")
    @JsonProperty(value="organization_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrganizationGuid() {
        return this.organizationGuid;
    }

    @JsonProperty(value="organization_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrganizationGuid(String organizationGuid) {
        this.organizationGuid = organizationGuid;
    }

    public BankBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public BankBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BankBankModel supportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
        return this;
    }

    public BankBankModel addSupportedTradingSymbolsItem(String supportedTradingSymbolsItem) {
        if (this.supportedTradingSymbols == null) {
            this.supportedTradingSymbols = new ArrayList<String>();
        }
        this.supportedTradingSymbols.add(supportedTradingSymbolsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bank's list of supported trading symbols.")
    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedTradingSymbols() {
        return this.supportedTradingSymbols;
    }

    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
    }

    public BankBankModel supportedFiatAccountAssets(List<String> supportedFiatAccountAssets) {
        this.supportedFiatAccountAssets = supportedFiatAccountAssets;
        return this;
    }

    public BankBankModel addSupportedFiatAccountAssetsItem(String supportedFiatAccountAssetsItem) {
        if (this.supportedFiatAccountAssets == null) {
            this.supportedFiatAccountAssets = new ArrayList<String>();
        }
        this.supportedFiatAccountAssets.add(supportedFiatAccountAssetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bank's list of supported fiat symbols.")
    @JsonProperty(value="supported_fiat_account_assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedFiatAccountAssets() {
        return this.supportedFiatAccountAssets;
    }

    @JsonProperty(value="supported_fiat_account_assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedFiatAccountAssets(List<String> supportedFiatAccountAssets) {
        this.supportedFiatAccountAssets = supportedFiatAccountAssets;
    }

    public BankBankModel supportedCountryCodes(List<String> supportedCountryCodes) {
        this.supportedCountryCodes = supportedCountryCodes;
        return this;
    }

    public BankBankModel addSupportedCountryCodesItem(String supportedCountryCodesItem) {
        if (this.supportedCountryCodes == null) {
            this.supportedCountryCodes = new ArrayList<String>();
        }
        this.supportedCountryCodes.add(supportedCountryCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bank's list of supported country codes.")
    @JsonProperty(value="supported_country_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedCountryCodes() {
        return this.supportedCountryCodes;
    }

    @JsonProperty(value="supported_country_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedCountryCodes(List<String> supportedCountryCodes) {
        this.supportedCountryCodes = supportedCountryCodes;
    }

    public BankBankModel features(List<FeaturesEnum> features) {
        this.features = features;
        return this;
    }

    public BankBankModel addFeaturesItem(FeaturesEnum featuresItem) {
        this.features.add(featuresItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's enabled features.")
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FeaturesEnum> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeatures(List<FeaturesEnum> features) {
        this.features = features;
    }

    public BankBankModel routableAccounts(RoutableAccountsEnum routableAccounts) {
        this.routableAccounts = routableAccounts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Configuration for supporting creating routable bank accounts.")
    @JsonProperty(value="routable_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoutableAccountsEnum getRoutableAccounts() {
        return this.routableAccounts;
    }

    @JsonProperty(value="routable_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutableAccounts(RoutableAccountsEnum routableAccounts) {
        this.routableAccounts = routableAccounts;
    }

    public BankBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ISO8601 datetime the bank was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankBankModel bank = (BankBankModel)o;
        return Objects.equals(this.guid, bank.guid) && Objects.equals(this.organizationGuid, bank.organizationGuid) && Objects.equals(this.name, bank.name) && Objects.equals((Object)this.type, (Object)bank.type) && Objects.equals(this.supportedTradingSymbols, bank.supportedTradingSymbols) && Objects.equals(this.supportedFiatAccountAssets, bank.supportedFiatAccountAssets) && Objects.equals(this.supportedCountryCodes, bank.supportedCountryCodes) && Objects.equals(this.features, bank.features) && Objects.equals((Object)this.routableAccounts, (Object)bank.routableAccounts) && Objects.equals(this.createdAt, bank.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.organizationGuid, this.name, this.type, this.supportedTradingSymbols, this.supportedFiatAccountAssets, this.supportedCountryCodes, this.features, this.routableAccounts, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    organizationGuid: ").append(this.toIndentedString(this.organizationGuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    supportedTradingSymbols: ").append(this.toIndentedString(this.supportedTradingSymbols)).append("\n");
        sb.append("    supportedFiatAccountAssets: ").append(this.toIndentedString(this.supportedFiatAccountAssets)).append("\n");
        sb.append("    supportedCountryCodes: ").append(this.toIndentedString(this.supportedCountryCodes)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    routableAccounts: ").append(this.toIndentedString((Object)this.routableAccounts)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoutableAccountsEnum {
        UNSUPPORTED("unsupported"),
        BANK("bank"),
        CUSTOMER("customer");

        private String value;

        private RoutableAccountsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoutableAccountsEnum fromValue(String value) {
            for (RoutableAccountsEnum b : RoutableAccountsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FeaturesEnum {
        ATTESTATION_IDENTITY_RECORDS("attestation_identity_records"),
        KYC_IDENTITY_VERIFICATIONS("kyc_identity_verifications"),
        RAW_ROUTING_DETAILS("raw_routing_details");

        private String value;

        private FeaturesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeaturesEnum fromValue(String value) {
            for (FeaturesEnum b : FeaturesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        SANDBOX("sandbox"),
        PRODUCTION("production");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

