/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostTradeBankModel;
import app.cybrid.cybrid_api_bank.client.model.TradeBankModel;
import app.cybrid.cybrid_api_bank.client.model.TradeListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class TradesBankApi {
    private ApiClient apiClient;

    public TradesBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public TradesBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createTradeRequestCreation(PostTradeBankModel postTradeBankModel) throws WebClientResponseException {
        PostTradeBankModel postBody = postTradeBankModel;
        if (postTradeBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postTradeBankModel' when calling createTrade", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TradeBankModel> localVarReturnType = new ParameterizedTypeReference<TradeBankModel>(){};
        return this.apiClient.invokeAPI("/api/trades", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TradeBankModel> createTrade(PostTradeBankModel postTradeBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<TradeBankModel> localVarReturnType = new ParameterizedTypeReference<TradeBankModel>(){};
        return this.createTradeRequestCreation(postTradeBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TradeBankModel>> createTradeWithHttpInfo(PostTradeBankModel postTradeBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<TradeBankModel> localVarReturnType = new ParameterizedTypeReference<TradeBankModel>(){};
        return this.createTradeRequestCreation(postTradeBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getTradeRequestCreation(String tradeGuid) throws WebClientResponseException {
        Object postBody = null;
        if (tradeGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'tradeGuid' when calling getTrade", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("trade_guid", tradeGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TradeBankModel> localVarReturnType = new ParameterizedTypeReference<TradeBankModel>(){};
        return this.apiClient.invokeAPI("/api/trades/{trade_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TradeBankModel> getTrade(String tradeGuid) throws WebClientResponseException {
        ParameterizedTypeReference<TradeBankModel> localVarReturnType = new ParameterizedTypeReference<TradeBankModel>(){};
        return this.getTradeRequestCreation(tradeGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TradeBankModel>> getTradeWithHttpInfo(String tradeGuid) throws WebClientResponseException {
        ParameterizedTypeReference<TradeBankModel> localVarReturnType = new ParameterizedTypeReference<TradeBankModel>(){};
        return this.getTradeRequestCreation(tradeGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listTradesRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String accountGuid, String state, String label) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "account_guid", accountGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "label", label));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TradeListBankModel> localVarReturnType = new ParameterizedTypeReference<TradeListBankModel>(){};
        return this.apiClient.invokeAPI("/api/trades", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TradeListBankModel> listTrades(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String accountGuid, String state, String label) throws WebClientResponseException {
        ParameterizedTypeReference<TradeListBankModel> localVarReturnType = new ParameterizedTypeReference<TradeListBankModel>(){};
        return this.listTradesRequestCreation(page, perPage, guid, bankGuid, customerGuid, accountGuid, state, label).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TradeListBankModel>> listTradesWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String accountGuid, String state, String label) throws WebClientResponseException {
        ParameterizedTypeReference<TradeListBankModel> localVarReturnType = new ParameterizedTypeReference<TradeListBankModel>(){};
        return this.listTradesRequestCreation(page, perPage, guid, bankGuid, customerGuid, accountGuid, state, label).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

