/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "customer_guid", "type", "method", "created_at", "updated_at", "state", "outcome", "failure_codes"})
@JsonTypeName(value="IdentityVerification")
public class IdentityVerificationBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private OutcomeEnum outcome;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private List<String> failureCodes = null;

    public IdentityVerificationBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the identity verification.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public IdentityVerificationBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public IdentityVerificationBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of identity verification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public IdentityVerificationBankModel method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification method.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public IdentityVerificationBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public IdentityVerificationBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public IdentityVerificationBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the verification process.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public IdentityVerificationBankModel outcome(OutcomeEnum outcome) {
        this.outcome = outcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The outcome of the verification process.")
    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OutcomeEnum getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutcome(OutcomeEnum outcome) {
        this.outcome = outcome;
    }

    public IdentityVerificationBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
        return this;
    }

    public IdentityVerificationBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null) {
            this.failureCodes = new ArrayList<String>();
        }
        this.failureCodes.add(failureCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFailureCodes() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationBankModel identityVerification = (IdentityVerificationBankModel)o;
        return Objects.equals(this.guid, identityVerification.guid) && Objects.equals(this.customerGuid, identityVerification.customerGuid) && Objects.equals((Object)this.type, (Object)identityVerification.type) && Objects.equals((Object)this.method, (Object)identityVerification.method) && Objects.equals(this.createdAt, identityVerification.createdAt) && Objects.equals(this.updatedAt, identityVerification.updatedAt) && Objects.equals((Object)this.state, (Object)identityVerification.state) && Objects.equals((Object)this.outcome, (Object)identityVerification.outcome) && Objects.equals(this.failureCodes, identityVerification.failureCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.customerGuid, this.type, this.method, this.createdAt, this.updatedAt, this.state, this.outcome, this.failureCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString((Object)this.outcome)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OutcomeEnum {
        PASSED("passed"),
        FAILED("failed");

        private String value;

        private OutcomeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OutcomeEnum fromValue(String value) {
            for (OutcomeEnum b : OutcomeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StateEnum {
        STORING("storing"),
        WAITING("waiting"),
        EXPIRED("expired"),
        COMPLETED("completed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MethodEnum {
        BUSINESS_REGISTRATION("business_registration"),
        ID_AND_SELFIE("id_and_selfie"),
        ATTESTED("attested"),
        PLAID_IDENTITY_MATCH("plaid_identity_match");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        KYC("kyc"),
        BANK_ACCOUNT("bank_account");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

