/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "type", "supported_trading_symbols", "features", "supported_fiat_account_assets", "supported_country_codes", "routable_accounts"})
@JsonTypeName(value="PostBank")
public class PostBankBankModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SUPPORTED_TRADING_SYMBOLS = "supported_trading_symbols";
    private List<String> supportedTradingSymbols = new ArrayList<String>();
    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<FeaturesEnum> features = new ArrayList<FeaturesEnum>();
    public static final String JSON_PROPERTY_SUPPORTED_FIAT_ACCOUNT_ASSETS = "supported_fiat_account_assets";
    private List<String> supportedFiatAccountAssets = new ArrayList<String>();
    public static final String JSON_PROPERTY_SUPPORTED_COUNTRY_CODES = "supported_country_codes";
    private List<String> supportedCountryCodes = null;
    public static final String JSON_PROPERTY_ROUTABLE_ACCOUNTS = "routable_accounts";
    private RoutableAccountsEnum routableAccounts;

    public PostBankBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PostBankBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's type. At present, only **sandbox** is supported.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostBankBankModel supportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
        return this;
    }

    public PostBankBankModel addSupportedTradingSymbolsItem(String supportedTradingSymbolsItem) {
        this.supportedTradingSymbols.add(supportedTradingSymbolsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's list of supported trading symbols.")
    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSupportedTradingSymbols() {
        return this.supportedTradingSymbols;
    }

    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
    }

    public PostBankBankModel features(List<FeaturesEnum> features) {
        this.features = features;
        return this;
    }

    public PostBankBankModel addFeaturesItem(FeaturesEnum featuresItem) {
        this.features.add(featuresItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's enabled features.")
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FeaturesEnum> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeatures(List<FeaturesEnum> features) {
        this.features = features;
    }

    public PostBankBankModel supportedFiatAccountAssets(List<String> supportedFiatAccountAssets) {
        this.supportedFiatAccountAssets = supportedFiatAccountAssets;
        return this;
    }

    public PostBankBankModel addSupportedFiatAccountAssetsItem(String supportedFiatAccountAssetsItem) {
        this.supportedFiatAccountAssets.add(supportedFiatAccountAssetsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's list of supported fiat assets.")
    @JsonProperty(value="supported_fiat_account_assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSupportedFiatAccountAssets() {
        return this.supportedFiatAccountAssets;
    }

    @JsonProperty(value="supported_fiat_account_assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedFiatAccountAssets(List<String> supportedFiatAccountAssets) {
        this.supportedFiatAccountAssets = supportedFiatAccountAssets;
    }

    public PostBankBankModel supportedCountryCodes(List<String> supportedCountryCodes) {
        this.supportedCountryCodes = supportedCountryCodes;
        return this;
    }

    public PostBankBankModel addSupportedCountryCodesItem(String supportedCountryCodesItem) {
        if (this.supportedCountryCodes == null) {
            this.supportedCountryCodes = new ArrayList<String>();
        }
        this.supportedCountryCodes.add(supportedCountryCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bank's list of supported country codes.")
    @JsonProperty(value="supported_country_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedCountryCodes() {
        return this.supportedCountryCodes;
    }

    @JsonProperty(value="supported_country_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedCountryCodes(List<String> supportedCountryCodes) {
        this.supportedCountryCodes = supportedCountryCodes;
    }

    public PostBankBankModel routableAccounts(RoutableAccountsEnum routableAccounts) {
        this.routableAccounts = routableAccounts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Configuration for supporting creating routable bank accounts.")
    @JsonProperty(value="routable_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoutableAccountsEnum getRoutableAccounts() {
        return this.routableAccounts;
    }

    @JsonProperty(value="routable_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutableAccounts(RoutableAccountsEnum routableAccounts) {
        this.routableAccounts = routableAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostBankBankModel postBank = (PostBankBankModel)o;
        return Objects.equals(this.name, postBank.name) && Objects.equals((Object)this.type, (Object)postBank.type) && Objects.equals(this.supportedTradingSymbols, postBank.supportedTradingSymbols) && Objects.equals(this.features, postBank.features) && Objects.equals(this.supportedFiatAccountAssets, postBank.supportedFiatAccountAssets) && Objects.equals(this.supportedCountryCodes, postBank.supportedCountryCodes) && Objects.equals((Object)this.routableAccounts, (Object)postBank.routableAccounts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.supportedTradingSymbols, this.features, this.supportedFiatAccountAssets, this.supportedCountryCodes, this.routableAccounts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostBankBankModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    supportedTradingSymbols: ").append(this.toIndentedString(this.supportedTradingSymbols)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    supportedFiatAccountAssets: ").append(this.toIndentedString(this.supportedFiatAccountAssets)).append("\n");
        sb.append("    supportedCountryCodes: ").append(this.toIndentedString(this.supportedCountryCodes)).append("\n");
        sb.append("    routableAccounts: ").append(this.toIndentedString((Object)this.routableAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoutableAccountsEnum {
        UNSUPPORTED("unsupported"),
        BANK("bank"),
        CUSTOMER("customer");

        private String value;

        private RoutableAccountsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoutableAccountsEnum fromValue(String value) {
            for (RoutableAccountsEnum b : RoutableAccountsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FeaturesEnum {
        ATTESTATION_IDENTITY_RECORDS("attestation_identity_records"),
        KYC_IDENTITY_VERIFICATIONS("kyc_identity_verifications"),
        BUSINESS_CUSTOMERS("business_customers"),
        INDIVIDUAL_CUSTOMERS("individual_customers");

        private String value;

        private FeaturesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeaturesEnum fromValue(String value) {
            for (FeaturesEnum b : FeaturesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        SANDBOX("sandbox");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

