/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"type", "code", "name", "symbol", "decimals"})
@JsonTypeName(value="Asset")
public class AssetBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_DECIMALS = "decimals";
    private BigInteger decimals;

    public AssetBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The asset type; one of fiat or crypto.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public AssetBankModel code(String code) {
        this.code = code;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The unique code for the asset.")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCode(String code) {
        this.code = code;
    }

    public AssetBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the asset.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public AssetBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The currency symbol for the asset.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public AssetBankModel decimals(BigInteger decimals) {
        this.decimals = decimals;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of decimals for the default unit of the asset.")
    @JsonProperty(value="decimals")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigInteger getDecimals() {
        return this.decimals;
    }

    @JsonProperty(value="decimals")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDecimals(BigInteger decimals) {
        this.decimals = decimals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetBankModel asset = (AssetBankModel)o;
        return Objects.equals(this.type, asset.type) && Objects.equals(this.code, asset.code) && Objects.equals(this.name, asset.name) && Objects.equals(this.symbol, asset.symbol) && Objects.equals(this.decimals, asset.decimals);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.code, this.name, this.symbol, this.decimals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    decimals: ").append(this.toIndentedString(this.decimals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

