/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "state", "failure_codes"})
@JsonTypeName(value="VerificationCheck")
public class VerificationCheckBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private List<String> failureCodes = null;

    public VerificationCheckBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of verification check.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public VerificationCheckBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The state of the verification check.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public VerificationCheckBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
        return this;
    }

    public VerificationCheckBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null) {
            this.failureCodes = new ArrayList<String>();
        }
        this.failureCodes.add(failureCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFailureCodes() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationCheckBankModel verificationCheck = (VerificationCheckBankModel)o;
        return Objects.equals((Object)this.type, (Object)verificationCheck.type) && Objects.equals((Object)this.state, (Object)verificationCheck.state) && Objects.equals(this.failureCodes, verificationCheck.failureCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.state, this.failureCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationCheckBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        PASSED("passed"),
        FAILED("failed"),
        EXPIRED("expired"),
        INVALIDATED("invalidated");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BUSINESS_WATCHLISTS("business_watchlists"),
        BUSINESS_VERIFICATION("business_verification"),
        BUSINESS_TAX_ID_VERIFICATION("business_tax_id_verification"),
        PERSON_ATTESTED("person_attested"),
        PERSON_TAX_ID_ATTESTED("person_tax_id_attested"),
        PERSON_WATCHLISTS("person_watchlists"),
        PERSON_VERIFICATION("person_verification"),
        PERSON_AUTHENTICATION("person_authentication"),
        PERSON_GOV_ID_VERIFICATION("person_gov_id_verification"),
        PERSON_TAX_ID_VERIFICATION("person_tax_id_verification");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

