/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.InvoiceBankModel;
import app.cybrid.cybrid_api_bank.client.model.InvoiceListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostInvoiceBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class InvoicesBankApi {
    private ApiClient apiClient;

    public InvoicesBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoicesBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelInvoiceRequestCreation(String invoiceGuid) throws WebClientResponseException {
        Object postBody = null;
        if (invoiceGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'invoiceGuid' when calling cancelInvoice", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("invoice_guid", invoiceGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.apiClient.invokeAPI("/api/invoices/{invoice_guid}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceBankModel> cancelInvoice(String invoiceGuid) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.cancelInvoiceRequestCreation(invoiceGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceBankModel>> cancelInvoiceWithHttpInfo(String invoiceGuid) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.cancelInvoiceRequestCreation(invoiceGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createInvoiceRequestCreation(PostInvoiceBankModel postInvoiceBankModel) throws WebClientResponseException {
        PostInvoiceBankModel postBody = postInvoiceBankModel;
        if (postInvoiceBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postInvoiceBankModel' when calling createInvoice", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.apiClient.invokeAPI("/api/invoices", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceBankModel> createInvoice(PostInvoiceBankModel postInvoiceBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.createInvoiceRequestCreation(postInvoiceBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceBankModel>> createInvoiceWithHttpInfo(PostInvoiceBankModel postInvoiceBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.createInvoiceRequestCreation(postInvoiceBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getInvoiceRequestCreation(String invoiceGuid) throws WebClientResponseException {
        Object postBody = null;
        if (invoiceGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'invoiceGuid' when calling getInvoice", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("invoice_guid", invoiceGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.apiClient.invokeAPI("/api/invoices/{invoice_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceBankModel> getInvoice(String invoiceGuid) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.getInvoiceRequestCreation(invoiceGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceBankModel>> getInvoiceWithHttpInfo(String invoiceGuid) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceBankModel>(){};
        return this.getInvoiceRequestCreation(invoiceGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listInvoicesRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String accountGuid, String label) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "account_guid", accountGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "label", label));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<InvoiceListBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceListBankModel>(){};
        return this.apiClient.invokeAPI("/api/invoices", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceListBankModel> listInvoices(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String accountGuid, String label) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceListBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceListBankModel>(){};
        return this.listInvoicesRequestCreation(page, perPage, guid, bankGuid, customerGuid, accountGuid, label).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceListBankModel>> listInvoicesWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String accountGuid, String label) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceListBankModel> localVarReturnType = new ParameterizedTypeReference<InvoiceListBankModel>(){};
        return this.listInvoicesRequestCreation(page, perPage, guid, bankGuid, customerGuid, accountGuid, label).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

