/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostWorkflowBankModel;
import app.cybrid.cybrid_api_bank.client.model.WorkflowBankModel;
import app.cybrid.cybrid_api_bank.client.model.WorkflowWithDetailsBankModel;
import app.cybrid.cybrid_api_bank.client.model.WorkflowsListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class WorkflowsBankApi {
    private ApiClient apiClient;

    public WorkflowsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public WorkflowsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createWorkflowRequestCreation(PostWorkflowBankModel postWorkflowBankModel) throws WebClientResponseException {
        PostWorkflowBankModel postBody = postWorkflowBankModel;
        if (postWorkflowBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postWorkflowBankModel' when calling createWorkflow", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<WorkflowBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowBankModel>(){};
        return this.apiClient.invokeAPI("/api/workflows", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<WorkflowBankModel> createWorkflow(PostWorkflowBankModel postWorkflowBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<WorkflowBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowBankModel>(){};
        return this.createWorkflowRequestCreation(postWorkflowBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<WorkflowBankModel>> createWorkflowWithHttpInfo(PostWorkflowBankModel postWorkflowBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<WorkflowBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowBankModel>(){};
        return this.createWorkflowRequestCreation(postWorkflowBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getWorkflowRequestCreation(String workflowGuid) throws WebClientResponseException {
        Object postBody = null;
        if (workflowGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'workflowGuid' when calling getWorkflow", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("workflow_guid", workflowGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<WorkflowWithDetailsBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowWithDetailsBankModel>(){};
        return this.apiClient.invokeAPI("/api/workflows/{workflow_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<WorkflowWithDetailsBankModel> getWorkflow(String workflowGuid) throws WebClientResponseException {
        ParameterizedTypeReference<WorkflowWithDetailsBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowWithDetailsBankModel>(){};
        return this.getWorkflowRequestCreation(workflowGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<WorkflowWithDetailsBankModel>> getWorkflowWithHttpInfo(String workflowGuid) throws WebClientResponseException {
        ParameterizedTypeReference<WorkflowWithDetailsBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowWithDetailsBankModel>(){};
        return this.getWorkflowRequestCreation(workflowGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listWorkflowsRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<WorkflowsListBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowsListBankModel>(){};
        return this.apiClient.invokeAPI("/api/workflows", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<WorkflowsListBankModel> listWorkflows(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<WorkflowsListBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowsListBankModel>(){};
        return this.listWorkflowsRequestCreation(page, perPage, guid, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<WorkflowsListBankModel>> listWorkflowsWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<WorkflowsListBankModel> localVarReturnType = new ParameterizedTypeReference<WorkflowsListBankModel>(){};
        return this.listWorkflowsRequestCreation(page, perPage, guid, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

