/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.ComplianceDecisionBankModel;
import app.cybrid.cybrid_api_bank.client.model.CustomerAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.CustomerAliasesInnerBankModel;
import app.cybrid.cybrid_api_bank.client.model.CustomerNameBankModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "bank_guid", "type", "created_at", "updated_at", "state", "name", "address", "aliases", "website", "date_of_birth", "phone_number", "email_address", "labels", "compliance_decisions", "verification_checks"})
@JsonTypeName(value="Customer")
public class CustomerBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_NAME = "name";
    private CustomerNameBankModel name;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private CustomerAddressBankModel address;
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private List<CustomerAliasesInnerBankModel> aliases = null;
    public static final String JSON_PROPERTY_WEBSITE = "website";
    private String website;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private String phoneNumber;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;
    public static final String JSON_PROPERTY_COMPLIANCE_DECISIONS = "compliance_decisions";
    private List<ComplianceDecisionBankModel> complianceDecisions = null;
    public static final String JSON_PROPERTY_VERIFICATION_CHECKS = "verification_checks";
    private List<ComplianceDecisionBankModel> verificationChecks = null;

    public CustomerBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the customer.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public CustomerBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the customer's bank.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public CustomerBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer type; one of business or individual.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public CustomerBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public CustomerBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public CustomerBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer state; one of storing, unverified, verified, rejected, or frozen.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public CustomerBankModel name(CustomerNameBankModel name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomerNameBankModel getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(CustomerNameBankModel name) {
        this.name = name;
    }

    public CustomerBankModel address(CustomerAddressBankModel address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomerAddressBankModel getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(CustomerAddressBankModel address) {
        this.address = address;
    }

    public CustomerBankModel aliases(List<CustomerAliasesInnerBankModel> aliases) {
        this.aliases = aliases;
        return this;
    }

    public CustomerBankModel addAliasesItem(CustomerAliasesInnerBankModel aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<CustomerAliasesInnerBankModel>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's aliases. Only available for GET operations when 'include_pii' is set.")
    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CustomerAliasesInnerBankModel> getAliases() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAliases(List<CustomerAliasesInnerBankModel> aliases) {
        this.aliases = aliases;
    }

    public CustomerBankModel website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's website. Only available for GET operations when 'include_pii' is set.")
    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsite(String website) {
        this.website = website;
    }

    public CustomerBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's DOB. Only available for GET operations when 'include_pii' is set.")
    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public CustomerBankModel phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's phone number. Only available for GET operations when 'include_pii' is set.")
    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public CustomerBankModel emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's email address. Only available for GET operations when 'include_pii' is set.")
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public CustomerBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public CustomerBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the customer.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public CustomerBankModel complianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
        return this;
    }

    public CustomerBankModel addComplianceDecisionsItem(ComplianceDecisionBankModel complianceDecisionsItem) {
        if (this.complianceDecisions == null) {
            this.complianceDecisions = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.complianceDecisions.add(complianceDecisionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The compliance decisions associated with the customer.")
    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getComplianceDecisions() {
        return this.complianceDecisions;
    }

    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComplianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
    }

    public CustomerBankModel verificationChecks(List<ComplianceDecisionBankModel> verificationChecks) {
        this.verificationChecks = verificationChecks;
        return this;
    }

    public CustomerBankModel addVerificationChecksItem(ComplianceDecisionBankModel verificationChecksItem) {
        if (this.verificationChecks == null) {
            this.verificationChecks = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.verificationChecks.add(verificationChecksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated; use compliance_decisions instead.")
    @JsonProperty(value="verification_checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getVerificationChecks() {
        return this.verificationChecks;
    }

    @JsonProperty(value="verification_checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationChecks(List<ComplianceDecisionBankModel> verificationChecks) {
        this.verificationChecks = verificationChecks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerBankModel customer = (CustomerBankModel)o;
        return Objects.equals(this.guid, customer.guid) && Objects.equals(this.bankGuid, customer.bankGuid) && Objects.equals(this.type, customer.type) && Objects.equals(this.createdAt, customer.createdAt) && Objects.equals(this.updatedAt, customer.updatedAt) && Objects.equals(this.state, customer.state) && Objects.equals(this.name, customer.name) && Objects.equals(this.address, customer.address) && Objects.equals(this.aliases, customer.aliases) && Objects.equals(this.website, customer.website) && Objects.equals(this.dateOfBirth, customer.dateOfBirth) && Objects.equals(this.phoneNumber, customer.phoneNumber) && Objects.equals(this.emailAddress, customer.emailAddress) && Objects.equals(this.labels, customer.labels) && Objects.equals(this.complianceDecisions, customer.complianceDecisions) && Objects.equals(this.verificationChecks, customer.verificationChecks);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.bankGuid, this.type, this.createdAt, this.updatedAt, this.state, this.name, this.address, this.aliases, this.website, this.dateOfBirth, this.phoneNumber, this.emailAddress, this.labels, this.complianceDecisions, this.verificationChecks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    complianceDecisions: ").append(this.toIndentedString(this.complianceDecisions)).append("\n");
        sb.append("    verificationChecks: ").append(this.toIndentedString(this.verificationChecks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

