/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"quote_guid", "transfer_type", "source_account_guid", "destination_account_guid", "external_wallet_guid", "external_bank_account_guid", "payment_rail", "beneficiary_memo", "labels"})
@JsonTypeName(value="PostTransfer")
public class PostTransferBankModel {
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
    private TransferTypeEnum transferType;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_GUID = "source_account_guid";
    private String sourceAccountGuid;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_GUID = "destination_account_guid";
    private String destinationAccountGuid;
    public static final String JSON_PROPERTY_EXTERNAL_WALLET_GUID = "external_wallet_guid";
    private String externalWalletGuid;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;
    public static final String JSON_PROPERTY_PAYMENT_RAIL = "payment_rail";
    private String paymentRail;
    public static final String JSON_PROPERTY_BENEFICIARY_MEMO = "beneficiary_memo";
    private String beneficiaryMemo;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;

    public PostTransferBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public PostTransferBankModel transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of transfer.")
    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public PostTransferBankModel sourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source account's identifier. Required for book transfers.")
    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountGuid() {
        return this.sourceAccountGuid;
    }

    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
    }

    public PostTransferBankModel destinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination account's identifier. Required for book transfers.")
    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountGuid() {
        return this.destinationAccountGuid;
    }

    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
    }

    public PostTransferBankModel externalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's external wallet's identifier.")
    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalWalletGuid() {
        return this.externalWalletGuid;
    }

    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
    }

    public PostTransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's 'plaid' or 'plaid_processor_token' external bank account's identifier.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public PostTransferBankModel paymentRail(String paymentRail) {
        this.paymentRail = paymentRail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The desired payment rail to initiate the transfer for. Valid values are: ach, eft, wire. Valid for funding transfers only.")
    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentRail() {
        return this.paymentRail;
    }

    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentRail(String paymentRail) {
        this.paymentRail = paymentRail;
    }

    public PostTransferBankModel beneficiaryMemo(String beneficiaryMemo) {
        this.beneficiaryMemo = beneficiaryMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The memo to send to the counterparty.")
    @JsonProperty(value="beneficiary_memo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBeneficiaryMemo() {
        return this.beneficiaryMemo;
    }

    @JsonProperty(value="beneficiary_memo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeneficiaryMemo(String beneficiaryMemo) {
        this.beneficiaryMemo = beneficiaryMemo;
    }

    public PostTransferBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public PostTransferBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the transfer.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTransferBankModel postTransfer = (PostTransferBankModel)o;
        return Objects.equals(this.quoteGuid, postTransfer.quoteGuid) && Objects.equals((Object)this.transferType, (Object)postTransfer.transferType) && Objects.equals(this.sourceAccountGuid, postTransfer.sourceAccountGuid) && Objects.equals(this.destinationAccountGuid, postTransfer.destinationAccountGuid) && Objects.equals(this.externalWalletGuid, postTransfer.externalWalletGuid) && Objects.equals(this.externalBankAccountGuid, postTransfer.externalBankAccountGuid) && Objects.equals(this.paymentRail, postTransfer.paymentRail) && Objects.equals(this.beneficiaryMemo, postTransfer.beneficiaryMemo) && Objects.equals(this.labels, postTransfer.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quoteGuid, this.transferType, this.sourceAccountGuid, this.destinationAccountGuid, this.externalWalletGuid, this.externalBankAccountGuid, this.paymentRail, this.beneficiaryMemo, this.labels});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTransferBankModel {\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    sourceAccountGuid: ").append(this.toIndentedString(this.sourceAccountGuid)).append("\n");
        sb.append("    destinationAccountGuid: ").append(this.toIndentedString(this.destinationAccountGuid)).append("\n");
        sb.append("    externalWalletGuid: ").append(this.toIndentedString(this.externalWalletGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    paymentRail: ").append(this.toIndentedString(this.paymentRail)).append("\n");
        sb.append("    beneficiaryMemo: ").append(this.toIndentedString(this.beneficiaryMemo)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TransferTypeEnum {
        FUNDING("funding"),
        BOOK("book"),
        CRYPTO("crypto"),
        INSTANT_FUNDING("instant_funding"),
        INTER_ACCOUNT("inter_account");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransferTypeEnum fromValue(String value) {
            for (TransferTypeEnum b : TransferTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

