/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.ComplianceDecisionBankModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "customer_guid", "type", "method", "created_at", "updated_at", "state", "outcome", "failure_codes", "compliance_decisions", "verification_checks"})
@JsonTypeName(value="IdentityVerification")
public class IdentityVerificationBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private String outcome;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private List<String> failureCodes = null;
    public static final String JSON_PROPERTY_COMPLIANCE_DECISIONS = "compliance_decisions";
    private List<ComplianceDecisionBankModel> complianceDecisions = null;
    public static final String JSON_PROPERTY_VERIFICATION_CHECKS = "verification_checks";
    private List<ComplianceDecisionBankModel> verificationChecks = null;

    public IdentityVerificationBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the identity verification.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public IdentityVerificationBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification's identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public IdentityVerificationBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification type; one of kyc or bank_account.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public IdentityVerificationBankModel method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification method; one of business_registration, id_and_selfie, tax_id_and_selfie, attested, attested_ownership, account_ownership, plaid_identity_match, or document_submission.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    public IdentityVerificationBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public IdentityVerificationBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public IdentityVerificationBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification state; one of storing, waiting, expired, or completed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public IdentityVerificationBankModel outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification outcome; one of passed or failed.")
    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public IdentityVerificationBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
        return this;
    }

    public IdentityVerificationBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null) {
            this.failureCodes = new ArrayList<String>();
        }
        this.failureCodes.add(failureCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFailureCodes() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public IdentityVerificationBankModel complianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
        return this;
    }

    public IdentityVerificationBankModel addComplianceDecisionsItem(ComplianceDecisionBankModel complianceDecisionsItem) {
        if (this.complianceDecisions == null) {
            this.complianceDecisions = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.complianceDecisions.add(complianceDecisionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The compliance decisions associated with the identity verification.")
    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getComplianceDecisions() {
        return this.complianceDecisions;
    }

    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComplianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
    }

    public IdentityVerificationBankModel verificationChecks(List<ComplianceDecisionBankModel> verificationChecks) {
        this.verificationChecks = verificationChecks;
        return this;
    }

    public IdentityVerificationBankModel addVerificationChecksItem(ComplianceDecisionBankModel verificationChecksItem) {
        if (this.verificationChecks == null) {
            this.verificationChecks = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.verificationChecks.add(verificationChecksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated; use compliance_decisions instead.")
    @JsonProperty(value="verification_checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getVerificationChecks() {
        return this.verificationChecks;
    }

    @JsonProperty(value="verification_checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationChecks(List<ComplianceDecisionBankModel> verificationChecks) {
        this.verificationChecks = verificationChecks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationBankModel identityVerification = (IdentityVerificationBankModel)o;
        return Objects.equals(this.guid, identityVerification.guid) && Objects.equals(this.customerGuid, identityVerification.customerGuid) && Objects.equals(this.type, identityVerification.type) && Objects.equals(this.method, identityVerification.method) && Objects.equals(this.createdAt, identityVerification.createdAt) && Objects.equals(this.updatedAt, identityVerification.updatedAt) && Objects.equals(this.state, identityVerification.state) && Objects.equals(this.outcome, identityVerification.outcome) && Objects.equals(this.failureCodes, identityVerification.failureCodes) && Objects.equals(this.complianceDecisions, identityVerification.complianceDecisions) && Objects.equals(this.verificationChecks, identityVerification.verificationChecks);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.customerGuid, this.type, this.method, this.createdAt, this.updatedAt, this.state, this.outcome, this.failureCodes, this.complianceDecisions, this.verificationChecks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("    complianceDecisions: ").append(this.toIndentedString(this.complianceDecisions)).append("\n");
        sb.append("    verificationChecks: ").append(this.toIndentedString(this.verificationChecks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

