/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"trade_type", "quote_guid", "expected_error", "labels"})
@JsonTypeName(value="PostTrade")
public class PostTradeBankModel {
    public static final String JSON_PROPERTY_TRADE_TYPE = "trade_type";
    private TradeTypeEnum tradeType = TradeTypeEnum.PLATFORM;
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_EXPECTED_ERROR = "expected_error";
    private ExpectedErrorEnum expectedError;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;

    public PostTradeBankModel tradeType(TradeTypeEnum tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of trade.")
    @JsonProperty(value="trade_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TradeTypeEnum getTradeType() {
        return this.tradeType;
    }

    @JsonProperty(value="trade_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTradeType(TradeTypeEnum tradeType) {
        this.tradeType = tradeType;
    }

    public PostTradeBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public PostTradeBankModel expectedError(ExpectedErrorEnum expectedError) {
        this.expectedError = expectedError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected error to simulate trade failure.")
    @JsonProperty(value="expected_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExpectedErrorEnum getExpectedError() {
        return this.expectedError;
    }

    @JsonProperty(value="expected_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedError(ExpectedErrorEnum expectedError) {
        this.expectedError = expectedError;
    }

    public PostTradeBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public PostTradeBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the trade.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTradeBankModel postTrade = (PostTradeBankModel)o;
        return Objects.equals((Object)this.tradeType, (Object)postTrade.tradeType) && Objects.equals(this.quoteGuid, postTrade.quoteGuid) && Objects.equals((Object)this.expectedError, (Object)postTrade.expectedError) && Objects.equals(this.labels, postTrade.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tradeType, this.quoteGuid, this.expectedError, this.labels});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTradeBankModel {\n");
        sb.append("    tradeType: ").append(this.toIndentedString((Object)this.tradeType)).append("\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    expectedError: ").append(this.toIndentedString((Object)this.expectedError)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedErrorEnum {
        EXPIRED_QUOTE("expired_quote"),
        NON_SUFFICIENT_FUNDS("non_sufficient_funds");

        private String value;

        private ExpectedErrorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedErrorEnum fromValue(String value) {
            for (ExpectedErrorEnum b : ExpectedErrorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TradeTypeEnum {
        PLATFORM("platform"),
        EXIT("exit");

        private String value;

        private TradeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TradeTypeEnum fromValue(String value) {
            for (TradeTypeEnum b : TradeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

