/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.CounterpartyBankModel;
import app.cybrid.cybrid_api_bank.client.model.CounterpartyListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostCounterpartyBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class CounterpartiesBankApi {
    private ApiClient apiClient;

    public CounterpartiesBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public CounterpartiesBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCounterpartyRequestCreation(PostCounterpartyBankModel postCounterpartyBankModel) throws WebClientResponseException {
        PostCounterpartyBankModel postBody = postCounterpartyBankModel;
        if (postCounterpartyBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postCounterpartyBankModel' when calling createCounterparty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<CounterpartyBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyBankModel>(){};
        return this.apiClient.invokeAPI("/api/counterparties", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CounterpartyBankModel> createCounterparty(PostCounterpartyBankModel postCounterpartyBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<CounterpartyBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyBankModel>(){};
        return this.createCounterpartyRequestCreation(postCounterpartyBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CounterpartyBankModel>> createCounterpartyWithHttpInfo(PostCounterpartyBankModel postCounterpartyBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<CounterpartyBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyBankModel>(){};
        return this.createCounterpartyRequestCreation(postCounterpartyBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getCounterpartyRequestCreation(String counterpartyGuid, Boolean includePii) throws WebClientResponseException {
        Object postBody = null;
        if (counterpartyGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'counterpartyGuid' when calling getCounterparty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("counterparty_guid", counterpartyGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "include_pii", includePii));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<CounterpartyBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyBankModel>(){};
        return this.apiClient.invokeAPI("/api/counterparties/{counterparty_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CounterpartyBankModel> getCounterparty(String counterpartyGuid, Boolean includePii) throws WebClientResponseException {
        ParameterizedTypeReference<CounterpartyBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyBankModel>(){};
        return this.getCounterpartyRequestCreation(counterpartyGuid, includePii).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CounterpartyBankModel>> getCounterpartyWithHttpInfo(String counterpartyGuid, Boolean includePii) throws WebClientResponseException {
        ParameterizedTypeReference<CounterpartyBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyBankModel>(){};
        return this.getCounterpartyRequestCreation(counterpartyGuid, includePii).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listCounterpartiesRequestCreation(BigInteger page, BigInteger perPage, String bankGuid, String type, String customerGuid, String guid, String label) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "label", label));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<CounterpartyListBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyListBankModel>(){};
        return this.apiClient.invokeAPI("/api/counterparties", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CounterpartyListBankModel> listCounterparties(BigInteger page, BigInteger perPage, String bankGuid, String type, String customerGuid, String guid, String label) throws WebClientResponseException {
        ParameterizedTypeReference<CounterpartyListBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyListBankModel>(){};
        return this.listCounterpartiesRequestCreation(page, perPage, bankGuid, type, customerGuid, guid, label).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CounterpartyListBankModel>> listCounterpartiesWithHttpInfo(BigInteger page, BigInteger perPage, String bankGuid, String type, String customerGuid, String guid, String label) throws WebClientResponseException {
        ParameterizedTypeReference<CounterpartyListBankModel> localVarReturnType = new ParameterizedTypeReference<CounterpartyListBankModel>(){};
        return this.listCounterpartiesRequestCreation(page, perPage, bankGuid, type, customerGuid, guid, label).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

