/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostIdentificationNumberBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentityVerificationAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentityVerificationNameBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "method", "customer_guid", "country_code", "name", "address", "date_of_birth", "phone_number", "email_address", "identification_numbers", "external_bank_account_guid", "expected_behaviours"})
@JsonTypeName(value="PostIdentityVerification")
public class PostIdentityVerificationBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "country_code";
    private String countryCode;
    public static final String JSON_PROPERTY_NAME = "name";
    private PostIdentityVerificationNameBankModel name;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private PostIdentityVerificationAddressBankModel address;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private String phoneNumber;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_IDENTIFICATION_NUMBERS = "identification_numbers";
    private List<PostIdentificationNumberBankModel> identificationNumbers = null;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;
    public static final String JSON_PROPERTY_EXPECTED_BEHAVIOURS = "expected_behaviours";
    private List<ExpectedBehavioursEnum> expectedBehaviours = null;

    public PostIdentityVerificationBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of identity verification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostIdentityVerificationBankModel method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The identity verification method.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public PostIdentityVerificationBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostIdentityVerificationBankModel countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166 country 2-Alpha country the customer is being verified in; required when method is set to 'id_and_selfie'. If not present, will default to the Bank's configured country code.")
    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PostIdentityVerificationBankModel name(PostIdentityVerificationNameBankModel name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PostIdentityVerificationNameBankModel getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(PostIdentityVerificationNameBankModel name) {
        this.name = name;
    }

    public PostIdentityVerificationBankModel address(PostIdentityVerificationAddressBankModel address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PostIdentityVerificationAddressBankModel getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(PostIdentityVerificationAddressBankModel address) {
        this.address = address;
    }

    public PostIdentityVerificationBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's date of birth; required when type is set to 'kyc' and method is set to 'attested'.")
    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PostIdentityVerificationBankModel phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's phone number.")
    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PostIdentityVerificationBankModel emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's email address.")
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public PostIdentityVerificationBankModel identificationNumbers(List<PostIdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = identificationNumbers;
        return this;
    }

    public PostIdentityVerificationBankModel addIdentificationNumbersItem(PostIdentificationNumberBankModel identificationNumbersItem) {
        if (this.identificationNumbers == null) {
            this.identificationNumbers = new ArrayList<PostIdentificationNumberBankModel>();
        }
        this.identificationNumbers.add(identificationNumbersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identification numbers; required when type is set to 'kyc' and method is set to 'attested'.")
    @JsonProperty(value="identification_numbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PostIdentificationNumberBankModel> getIdentificationNumbers() {
        return this.identificationNumbers;
    }

    @JsonProperty(value="identification_numbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentificationNumbers(List<PostIdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = identificationNumbers;
    }

    public PostIdentityVerificationBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external bank account's identifier. Required for 'bank_account' type.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public PostIdentityVerificationBankModel expectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = expectedBehaviours;
        return this;
    }

    public PostIdentityVerificationBankModel addExpectedBehavioursItem(ExpectedBehavioursEnum expectedBehavioursItem) {
        if (this.expectedBehaviours == null) {
            this.expectedBehaviours = new ArrayList<ExpectedBehavioursEnum>();
        }
        this.expectedBehaviours.add(expectedBehavioursItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected behaviour to simulate.")
    @JsonProperty(value="expected_behaviours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExpectedBehavioursEnum> getExpectedBehaviours() {
        return this.expectedBehaviours;
    }

    @JsonProperty(value="expected_behaviours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = expectedBehaviours;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostIdentityVerificationBankModel postIdentityVerification = (PostIdentityVerificationBankModel)o;
        return Objects.equals((Object)this.type, (Object)postIdentityVerification.type) && Objects.equals((Object)this.method, (Object)postIdentityVerification.method) && Objects.equals(this.customerGuid, postIdentityVerification.customerGuid) && Objects.equals(this.countryCode, postIdentityVerification.countryCode) && Objects.equals(this.name, postIdentityVerification.name) && Objects.equals(this.address, postIdentityVerification.address) && Objects.equals(this.dateOfBirth, postIdentityVerification.dateOfBirth) && Objects.equals(this.phoneNumber, postIdentityVerification.phoneNumber) && Objects.equals(this.emailAddress, postIdentityVerification.emailAddress) && Objects.equals(this.identificationNumbers, postIdentityVerification.identificationNumbers) && Objects.equals(this.externalBankAccountGuid, postIdentityVerification.externalBankAccountGuid) && Objects.equals(this.expectedBehaviours, postIdentityVerification.expectedBehaviours);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.method, this.customerGuid, this.countryCode, this.name, this.address, this.dateOfBirth, this.phoneNumber, this.emailAddress, this.identificationNumbers, this.externalBankAccountGuid, this.expectedBehaviours});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostIdentityVerificationBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    identificationNumbers: ").append(this.toIndentedString(this.identificationNumbers)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    expectedBehaviours: ").append(this.toIndentedString(this.expectedBehaviours)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedBehavioursEnum {
        PASSED_IMMEDIATELY("passed_immediately"),
        FAILED_IMMEDIATELY("failed_immediately"),
        TAX_ID_NOT_CHECKED("tax_id_not_checked");

        private String value;

        private ExpectedBehavioursEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedBehavioursEnum fromValue(String value) {
            for (ExpectedBehavioursEnum b : ExpectedBehavioursEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MethodEnum {
        BUSINESS_REGISTRATION("business_registration"),
        ID_AND_SELFIE("id_and_selfie"),
        TAX_ID_AND_SELFIE("tax_id_and_selfie"),
        ATTESTED("attested"),
        ATTESTED_OWNERSHIP("attested_ownership"),
        ACCOUNT_OWNERSHIP("account_ownership"),
        PLAID_IDENTITY_MATCH("plaid_identity_match"),
        DOCUMENT_SUBMISSION("document_submission"),
        WATCHLISTS("watchlists");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        KYC("kyc"),
        BANK_ACCOUNT("bank_account"),
        COUNTERPARTY("counterparty");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

