/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "account_guid", "customer_guid", "parent_deposit_bank_account_guid", "labels"})
@JsonTypeName(value="PostDepositBankAccount")
public class PostDepositBankAccountBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private String accountGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_PARENT_DEPOSIT_BANK_ACCOUNT_GUID = "parent_deposit_bank_account_guid";
    private String parentDepositBankAccountGuid;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;

    public PostDepositBankAccountBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostDepositBankAccountBankModel accountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fiat account guid.")
    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountGuid() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
    }

    public PostDepositBankAccountBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostDepositBankAccountBankModel parentDepositBankAccountGuid(String parentDepositBankAccountGuid) {
        this.parentDepositBankAccountGuid = parentDepositBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the bank-level deposit bank account. This is only required for sub-accounts.")
    @JsonProperty(value="parent_deposit_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParentDepositBankAccountGuid() {
        return this.parentDepositBankAccountGuid;
    }

    @JsonProperty(value="parent_deposit_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentDepositBankAccountGuid(String parentDepositBankAccountGuid) {
        this.parentDepositBankAccountGuid = parentDepositBankAccountGuid;
    }

    public PostDepositBankAccountBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public PostDepositBankAccountBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the address.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostDepositBankAccountBankModel postDepositBankAccount = (PostDepositBankAccountBankModel)o;
        return Objects.equals((Object)this.type, (Object)postDepositBankAccount.type) && Objects.equals(this.accountGuid, postDepositBankAccount.accountGuid) && Objects.equals(this.customerGuid, postDepositBankAccount.customerGuid) && Objects.equals(this.parentDepositBankAccountGuid, postDepositBankAccount.parentDepositBankAccountGuid) && Objects.equals(this.labels, postDepositBankAccount.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.accountGuid, this.customerGuid, this.parentDepositBankAccountGuid, this.labels});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostDepositBankAccountBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    parentDepositBankAccountGuid: ").append(this.toIndentedString(this.parentDepositBankAccountGuid)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MAIN("main"),
        SUB_ACCOUNT("sub_account");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

