/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "outcome", "failure_codes"})
@JsonTypeName(value="ComplianceCheck")
public class ComplianceCheckBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private String outcome;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private List<String> failureCodes = null;

    public ComplianceCheckBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of compliance check; one of business_watchlists, business_verification, business_tax_id_verification, person_attested, person_tax_id_attested, person_watchlists, person_verification, person_authentication, person_gov_id_verification, person_tax_id_verification, external_bank_account_verification, or external_bank_account_attested.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ComplianceCheckBankModel outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The outcome of the compliance check; one of passed, failed, or inconclusive.")
    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public ComplianceCheckBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
        return this;
    }

    public ComplianceCheckBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null) {
            this.failureCodes = new ArrayList<String>();
        }
        this.failureCodes.add(failureCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFailureCodes() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceCheckBankModel complianceCheck = (ComplianceCheckBankModel)o;
        return Objects.equals(this.type, complianceCheck.type) && Objects.equals(this.outcome, complianceCheck.outcome) && Objects.equals(this.failureCodes, complianceCheck.failureCodes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.outcome, this.failureCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComplianceCheckBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

