/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostFeeBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"product_type", "bank_guid", "customer_guid", "asset", "network_address", "symbol", "side", "receive_amount", "deliver_amount", "fees", "reference_trade_guid", "source_account_guid", "destination_account_guid"})
@JsonTypeName(value="PostQuote")
public class PostQuoteBankModel {
    public static final String JSON_PROPERTY_PRODUCT_TYPE = "product_type";
    private ProductTypeEnum productType = ProductTypeEnum.TRADING;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_NETWORK_ADDRESS = "network_address";
    private String networkAddress;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_SIDE = "side";
    private String side;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;
    public static final String JSON_PROPERTY_FEES = "fees";
    private List<PostFeeBankModel> fees = null;
    public static final String JSON_PROPERTY_REFERENCE_TRADE_GUID = "reference_trade_guid";
    private String referenceTradeGuid;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_GUID = "source_account_guid";
    private String sourceAccountGuid;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_GUID = "destination_account_guid";
    private String destinationAccountGuid;

    public PostQuoteBankModel productType(ProductTypeEnum productType) {
        this.productType = productType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of product the quote is for.")
    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProductTypeEnum getProductType() {
        return this.productType;
    }

    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductType(ProductTypeEnum productType) {
        this.productType = productType;
    }

    public PostQuoteBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the bank.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public PostQuoteBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostQuoteBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code the quote was requested for. Populated for funding, book transfer and crypto transfer quotes.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public PostQuoteBankModel networkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network address to pay the invoice to. Populated for lightning_transfer quotes.")
    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public PostQuoteBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol the quote is being requested for. Format is \"asset-counter_asset\" in uppercase. See the Symbols API for a complete list of cryptocurrencies supported. Populated for trade quotes.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public PostQuoteBankModel side(String side) {
        this.side = side;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction for trade quotes: either 'buy' or 'sell'. The direction for funding quotes: either 'deposit' or 'withdrawal'. The direction for crypto transfer quotes: 'withdrawal'. Book transfers do not require a side. They are all 'deposit's. ")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSide(String side) {
        this.side = side;
    }

    public PostQuoteBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell for trade quotes.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public PostQuoteBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell for trade quotes.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public PostQuoteBankModel fees(List<PostFeeBankModel> fees) {
        this.fees = fees;
        return this;
    }

    public PostQuoteBankModel addFeesItem(PostFeeBankModel feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<PostFeeBankModel>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The custom fees associated with the quote")
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PostFeeBankModel> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFees(List<PostFeeBankModel> fees) {
        this.fees = fees;
    }

    public PostQuoteBankModel referenceTradeGuid(String referenceTradeGuid) {
        this.referenceTradeGuid = referenceTradeGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The guid of the related trade. Only present on `exit` trades.")
    @JsonProperty(value="reference_trade_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceTradeGuid() {
        return this.referenceTradeGuid;
    }

    @JsonProperty(value="reference_trade_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceTradeGuid(String referenceTradeGuid) {
        this.referenceTradeGuid = referenceTradeGuid;
    }

    public PostQuoteBankModel sourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source account's identifier. Required for inter-account transfers.")
    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountGuid() {
        return this.sourceAccountGuid;
    }

    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
    }

    public PostQuoteBankModel destinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination account's identifier. Required for inter-account transfers.")
    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountGuid() {
        return this.destinationAccountGuid;
    }

    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostQuoteBankModel postQuote = (PostQuoteBankModel)o;
        return Objects.equals((Object)this.productType, (Object)postQuote.productType) && Objects.equals(this.bankGuid, postQuote.bankGuid) && Objects.equals(this.customerGuid, postQuote.customerGuid) && Objects.equals(this.asset, postQuote.asset) && Objects.equals(this.networkAddress, postQuote.networkAddress) && Objects.equals(this.symbol, postQuote.symbol) && Objects.equals(this.side, postQuote.side) && Objects.equals(this.receiveAmount, postQuote.receiveAmount) && Objects.equals(this.deliverAmount, postQuote.deliverAmount) && Objects.equals(this.fees, postQuote.fees) && Objects.equals(this.referenceTradeGuid, postQuote.referenceTradeGuid) && Objects.equals(this.sourceAccountGuid, postQuote.sourceAccountGuid) && Objects.equals(this.destinationAccountGuid, postQuote.destinationAccountGuid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productType, this.bankGuid, this.customerGuid, this.asset, this.networkAddress, this.symbol, this.side, this.receiveAmount, this.deliverAmount, this.fees, this.referenceTradeGuid, this.sourceAccountGuid, this.destinationAccountGuid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostQuoteBankModel {\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    networkAddress: ").append(this.toIndentedString(this.networkAddress)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    side: ").append(this.toIndentedString(this.side)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    referenceTradeGuid: ").append(this.toIndentedString(this.referenceTradeGuid)).append("\n");
        sb.append("    sourceAccountGuid: ").append(this.toIndentedString(this.sourceAccountGuid)).append("\n");
        sb.append("    destinationAccountGuid: ").append(this.toIndentedString(this.destinationAccountGuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductTypeEnum {
        TRADING("trading"),
        TRADING_EXIT("trading_exit"),
        FUNDING("funding"),
        BOOK_TRANSFER("book_transfer"),
        CRYPTO_TRANSFER("crypto_transfer"),
        INTER_ACCOUNT("inter_account"),
        LIGHTNING_TRANSFER("lightning_transfer");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String value) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

