/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Request body for workflow creation.")
@JsonPropertyOrder(value={"type", "kind", "customer_guid", "external_bank_account_guid", "language", "link_customization_name", "redirect_uri", "android_package_name"})
@JsonTypeName(value="PostWorkflow")
public class PostWorkflowBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_KIND = "kind";
    private KindEnum kind;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private LanguageEnum language;
    public static final String JSON_PROPERTY_LINK_CUSTOMIZATION_NAME = "link_customization_name";
    private String linkCustomizationName;
    public static final String JSON_PROPERTY_REDIRECT_URI = "redirect_uri";
    private String redirectUri;
    public static final String JSON_PROPERTY_ANDROID_PACKAGE_NAME = "android_package_name";
    private String androidPackageName;

    public PostWorkflowBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The workflow type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostWorkflowBankModel kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid workflow kind. Required when type is plaid.")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KindEnum getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public PostWorkflowBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier associated with the workflow. Optional when type is plaid and kind is link_token_create.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostWorkflowBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external bank account identifier associated with the workflow. Required when type is plaid and kind is link_token_update.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public PostWorkflowBankModel language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The language to initialize Plaid link. Required when type is plaid.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LanguageEnum getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public PostWorkflowBankModel linkCustomizationName(String linkCustomizationName) {
        this.linkCustomizationName = linkCustomizationName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customization name for Plaid link. Currently only supports the value \"default\". Required when type is plaid.")
    @JsonProperty(value="link_customization_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLinkCustomizationName() {
        return this.linkCustomizationName;
    }

    @JsonProperty(value="link_customization_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinkCustomizationName(String linkCustomizationName) {
        this.linkCustomizationName = linkCustomizationName;
    }

    public PostWorkflowBankModel redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The redirect URI for Plaid link. Optional when type is plaid.")
    @JsonProperty(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @JsonProperty(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public PostWorkflowBankModel androidPackageName(String androidPackageName) {
        this.androidPackageName = androidPackageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Android package name for Plaid link. Optional when type is plaid.")
    @JsonProperty(value="android_package_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAndroidPackageName() {
        return this.androidPackageName;
    }

    @JsonProperty(value="android_package_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAndroidPackageName(String androidPackageName) {
        this.androidPackageName = androidPackageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostWorkflowBankModel postWorkflow = (PostWorkflowBankModel)o;
        return Objects.equals((Object)this.type, (Object)postWorkflow.type) && Objects.equals((Object)this.kind, (Object)postWorkflow.kind) && Objects.equals(this.customerGuid, postWorkflow.customerGuid) && Objects.equals(this.externalBankAccountGuid, postWorkflow.externalBankAccountGuid) && Objects.equals((Object)this.language, (Object)postWorkflow.language) && Objects.equals(this.linkCustomizationName, postWorkflow.linkCustomizationName) && Objects.equals(this.redirectUri, postWorkflow.redirectUri) && Objects.equals(this.androidPackageName, postWorkflow.androidPackageName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.kind, this.customerGuid, this.externalBankAccountGuid, this.language, this.linkCustomizationName, this.redirectUri, this.androidPackageName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostWorkflowBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    linkCustomizationName: ").append(this.toIndentedString(this.linkCustomizationName)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    androidPackageName: ").append(this.toIndentedString(this.androidPackageName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LanguageEnum {
        EN("en"),
        FR("fr"),
        ES("es"),
        NL("nl"),
        DE("de");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum KindEnum {
        CREATE("link_token_create"),
        UPDATE("link_token_update");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        PLAID("plaid");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

