/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostTransferParticipantBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Request body for transfer creation.")
@JsonPropertyOrder(value={"quote_guid", "transfer_type", "external_bank_account_guid", "fiat_account_guid", "send_as_deposit_bank_account_guid", "payment_rail", "beneficiary_memo", "source_participants", "destination_participants", "bank_fiat_account_guid", "customer_fiat_account_guid", "source_account_guid", "destination_account_guid", "external_wallet_guid", "customer_guid", "network_fee_account_guid", "labels"})
@JsonTypeName(value="PostTransfer")
public class PostTransferBankModel {
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
    private TransferTypeEnum transferType;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;
    public static final String JSON_PROPERTY_FIAT_ACCOUNT_GUID = "fiat_account_guid";
    private String fiatAccountGuid;
    public static final String JSON_PROPERTY_SEND_AS_DEPOSIT_BANK_ACCOUNT_GUID = "send_as_deposit_bank_account_guid";
    private String sendAsDepositBankAccountGuid;
    public static final String JSON_PROPERTY_PAYMENT_RAIL = "payment_rail";
    private PaymentRailEnum paymentRail;
    public static final String JSON_PROPERTY_BENEFICIARY_MEMO = "beneficiary_memo";
    private String beneficiaryMemo;
    public static final String JSON_PROPERTY_SOURCE_PARTICIPANTS = "source_participants";
    private List<PostTransferParticipantBankModel> sourceParticipants = null;
    public static final String JSON_PROPERTY_DESTINATION_PARTICIPANTS = "destination_participants";
    private List<PostTransferParticipantBankModel> destinationParticipants = null;
    public static final String JSON_PROPERTY_BANK_FIAT_ACCOUNT_GUID = "bank_fiat_account_guid";
    private String bankFiatAccountGuid;
    public static final String JSON_PROPERTY_CUSTOMER_FIAT_ACCOUNT_GUID = "customer_fiat_account_guid";
    private String customerFiatAccountGuid;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_GUID = "source_account_guid";
    private String sourceAccountGuid;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_GUID = "destination_account_guid";
    private String destinationAccountGuid;
    public static final String JSON_PROPERTY_EXTERNAL_WALLET_GUID = "external_wallet_guid";
    private String externalWalletGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_NETWORK_FEE_ACCOUNT_GUID = "network_fee_account_guid";
    private String networkFeeAccountGuid;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;

    public PostTransferBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public PostTransferBankModel transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of transfer.")
    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public PostTransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's 'plaid' or 'plaid_processor_token' external bank account's identifier. Required when transfer_type is funding or transfer_type is instant_funding.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public PostTransferBankModel fiatAccountGuid(String fiatAccountGuid) {
        this.fiatAccountGuid = fiatAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the transfer. Required if the customer or bank has multiple fiat accounts. Optional when transfer_type is funding.")
    @JsonProperty(value="fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFiatAccountGuid() {
        return this.fiatAccountGuid;
    }

    @JsonProperty(value="fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiatAccountGuid(String fiatAccountGuid) {
        this.fiatAccountGuid = fiatAccountGuid;
    }

    public PostTransferBankModel sendAsDepositBankAccountGuid(String sendAsDepositBankAccountGuid) {
        this.sendAsDepositBankAccountGuid = sendAsDepositBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The deposit bank account's identifier. Only valid for withdrawals. The deposit bank account must be owned by the customer or bank initiating the transfer. Optional when transfer_type is funding.")
    @JsonProperty(value="send_as_deposit_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSendAsDepositBankAccountGuid() {
        return this.sendAsDepositBankAccountGuid;
    }

    @JsonProperty(value="send_as_deposit_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendAsDepositBankAccountGuid(String sendAsDepositBankAccountGuid) {
        this.sendAsDepositBankAccountGuid = sendAsDepositBankAccountGuid;
    }

    public PostTransferBankModel paymentRail(PaymentRailEnum paymentRail) {
        this.paymentRail = paymentRail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The desired payment rail to initiate the transfer for. Optional when transfer_type is funding.")
    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentRailEnum getPaymentRail() {
        return this.paymentRail;
    }

    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentRail(PaymentRailEnum paymentRail) {
        this.paymentRail = paymentRail;
    }

    public PostTransferBankModel beneficiaryMemo(String beneficiaryMemo) {
        this.beneficiaryMemo = beneficiaryMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The memo to send to the counterparty. Optional when transfer_type is funding.")
    @JsonProperty(value="beneficiary_memo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBeneficiaryMemo() {
        return this.beneficiaryMemo;
    }

    @JsonProperty(value="beneficiary_memo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeneficiaryMemo(String beneficiaryMemo) {
        this.beneficiaryMemo = beneficiaryMemo;
    }

    public PostTransferBankModel sourceParticipants(List<PostTransferParticipantBankModel> sourceParticipants) {
        this.sourceParticipants = sourceParticipants;
        return this;
    }

    public PostTransferBankModel addSourceParticipantsItem(PostTransferParticipantBankModel sourceParticipantsItem) {
        if (this.sourceParticipants == null) {
            this.sourceParticipants = new ArrayList<PostTransferParticipantBankModel>();
        }
        this.sourceParticipants.add(sourceParticipantsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source participants for the transfer. Optional when transfer_type is funding, transfer_type is instant_funding, transfer_type is book, transfer_type is crypto, or transfer_type is lightning.")
    @JsonProperty(value="source_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PostTransferParticipantBankModel> getSourceParticipants() {
        return this.sourceParticipants;
    }

    @JsonProperty(value="source_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceParticipants(List<PostTransferParticipantBankModel> sourceParticipants) {
        this.sourceParticipants = sourceParticipants;
    }

    public PostTransferBankModel destinationParticipants(List<PostTransferParticipantBankModel> destinationParticipants) {
        this.destinationParticipants = destinationParticipants;
        return this;
    }

    public PostTransferBankModel addDestinationParticipantsItem(PostTransferParticipantBankModel destinationParticipantsItem) {
        if (this.destinationParticipants == null) {
            this.destinationParticipants = new ArrayList<PostTransferParticipantBankModel>();
        }
        this.destinationParticipants.add(destinationParticipantsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination participants for the transfer. Optional when transfer_type is funding, transfer_type is instant_funding, transfer_type is book, transfer_type is crypto, or transfer_type is lightning.")
    @JsonProperty(value="destination_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PostTransferParticipantBankModel> getDestinationParticipants() {
        return this.destinationParticipants;
    }

    @JsonProperty(value="destination_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationParticipants(List<PostTransferParticipantBankModel> destinationParticipants) {
        this.destinationParticipants = destinationParticipants;
    }

    public PostTransferBankModel bankFiatAccountGuid(String bankFiatAccountGuid) {
        this.bankFiatAccountGuid = bankFiatAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the transfer. Required if the bank has multiple fiat accounts. Optional when transfer_type is instant_funding or transfer_type is lightning.")
    @JsonProperty(value="bank_fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankFiatAccountGuid() {
        return this.bankFiatAccountGuid;
    }

    @JsonProperty(value="bank_fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankFiatAccountGuid(String bankFiatAccountGuid) {
        this.bankFiatAccountGuid = bankFiatAccountGuid;
    }

    public PostTransferBankModel customerFiatAccountGuid(String customerFiatAccountGuid) {
        this.customerFiatAccountGuid = customerFiatAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the transfer. Required if the customer has multiple fiat accounts. Optional when transfer_type is instant_funding or transfer_type is lightning.")
    @JsonProperty(value="customer_fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerFiatAccountGuid() {
        return this.customerFiatAccountGuid;
    }

    @JsonProperty(value="customer_fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerFiatAccountGuid(String customerFiatAccountGuid) {
        this.customerFiatAccountGuid = customerFiatAccountGuid;
    }

    public PostTransferBankModel sourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source account's identifier. Required when transfer_type is book or transfer_type is inter_account.")
    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountGuid() {
        return this.sourceAccountGuid;
    }

    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
    }

    public PostTransferBankModel destinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination account's identifier. Required when transfer_type is book or transfer_type is inter_account.")
    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountGuid() {
        return this.destinationAccountGuid;
    }

    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
    }

    public PostTransferBankModel externalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's external wallet's identifier. Required when transfer_type is crypto.")
    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalWalletGuid() {
        return this.externalWalletGuid;
    }

    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
    }

    public PostTransferBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier. Required when transfer_type is lightning.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostTransferBankModel networkFeeAccountGuid(String networkFeeAccountGuid) {
        this.networkFeeAccountGuid = networkFeeAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network fee account's identifier. Required for network fee transfers. Must be the identifier for the customer's or bank's fiat or trading account. For customer's to pay the network fees, include the customer's fiat or trading account guid. For bank's to pay the network fees, include the bank's fiat or trading account guid. Required when transfer_type is lightning.")
    @JsonProperty(value="network_fee_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkFeeAccountGuid() {
        return this.networkFeeAccountGuid;
    }

    @JsonProperty(value="network_fee_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFeeAccountGuid(String networkFeeAccountGuid) {
        this.networkFeeAccountGuid = networkFeeAccountGuid;
    }

    public PostTransferBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public PostTransferBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the transfer.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTransferBankModel postTransfer = (PostTransferBankModel)o;
        return Objects.equals(this.quoteGuid, postTransfer.quoteGuid) && Objects.equals((Object)this.transferType, (Object)postTransfer.transferType) && Objects.equals(this.externalBankAccountGuid, postTransfer.externalBankAccountGuid) && Objects.equals(this.fiatAccountGuid, postTransfer.fiatAccountGuid) && Objects.equals(this.sendAsDepositBankAccountGuid, postTransfer.sendAsDepositBankAccountGuid) && Objects.equals((Object)this.paymentRail, (Object)postTransfer.paymentRail) && Objects.equals(this.beneficiaryMemo, postTransfer.beneficiaryMemo) && Objects.equals(this.sourceParticipants, postTransfer.sourceParticipants) && Objects.equals(this.destinationParticipants, postTransfer.destinationParticipants) && Objects.equals(this.bankFiatAccountGuid, postTransfer.bankFiatAccountGuid) && Objects.equals(this.customerFiatAccountGuid, postTransfer.customerFiatAccountGuid) && Objects.equals(this.sourceAccountGuid, postTransfer.sourceAccountGuid) && Objects.equals(this.destinationAccountGuid, postTransfer.destinationAccountGuid) && Objects.equals(this.externalWalletGuid, postTransfer.externalWalletGuid) && Objects.equals(this.customerGuid, postTransfer.customerGuid) && Objects.equals(this.networkFeeAccountGuid, postTransfer.networkFeeAccountGuid) && Objects.equals(this.labels, postTransfer.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quoteGuid, this.transferType, this.externalBankAccountGuid, this.fiatAccountGuid, this.sendAsDepositBankAccountGuid, this.paymentRail, this.beneficiaryMemo, this.sourceParticipants, this.destinationParticipants, this.bankFiatAccountGuid, this.customerFiatAccountGuid, this.sourceAccountGuid, this.destinationAccountGuid, this.externalWalletGuid, this.customerGuid, this.networkFeeAccountGuid, this.labels});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTransferBankModel {\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    fiatAccountGuid: ").append(this.toIndentedString(this.fiatAccountGuid)).append("\n");
        sb.append("    sendAsDepositBankAccountGuid: ").append(this.toIndentedString(this.sendAsDepositBankAccountGuid)).append("\n");
        sb.append("    paymentRail: ").append(this.toIndentedString((Object)this.paymentRail)).append("\n");
        sb.append("    beneficiaryMemo: ").append(this.toIndentedString(this.beneficiaryMemo)).append("\n");
        sb.append("    sourceParticipants: ").append(this.toIndentedString(this.sourceParticipants)).append("\n");
        sb.append("    destinationParticipants: ").append(this.toIndentedString(this.destinationParticipants)).append("\n");
        sb.append("    bankFiatAccountGuid: ").append(this.toIndentedString(this.bankFiatAccountGuid)).append("\n");
        sb.append("    customerFiatAccountGuid: ").append(this.toIndentedString(this.customerFiatAccountGuid)).append("\n");
        sb.append("    sourceAccountGuid: ").append(this.toIndentedString(this.sourceAccountGuid)).append("\n");
        sb.append("    destinationAccountGuid: ").append(this.toIndentedString(this.destinationAccountGuid)).append("\n");
        sb.append("    externalWalletGuid: ").append(this.toIndentedString(this.externalWalletGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    networkFeeAccountGuid: ").append(this.toIndentedString(this.networkFeeAccountGuid)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PaymentRailEnum {
        ACH("ach"),
        EFT("eft"),
        WIRE("wire"),
        RTP("rtp");

        private String value;

        private PaymentRailEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentRailEnum fromValue(String value) {
            for (PaymentRailEnum b : PaymentRailEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TransferTypeEnum {
        FUNDING("funding"),
        BOOK("book"),
        CRYPTO("crypto"),
        INSTANT_FUNDING("instant_funding"),
        INTER_ACCOUNT("inter_account"),
        LIGHTNING("lightning");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransferTypeEnum fromValue(String value) {
            for (TransferTypeEnum b : TransferTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

