/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Request body for payment instruction creation.")
@JsonPropertyOrder(value={"invoice_guid", "expected_behaviour"})
@JsonTypeName(value="PostPaymentInstruction")
public class PostPaymentInstructionBankModel {
    public static final String JSON_PROPERTY_INVOICE_GUID = "invoice_guid";
    private String invoiceGuid;
    public static final String JSON_PROPERTY_EXPECTED_BEHAVIOUR = "expected_behaviour";
    private ExpectedBehaviourEnum expectedBehaviour;

    public PostPaymentInstructionBankModel invoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The invoice guid.")
    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInvoiceGuid() {
        return this.invoiceGuid;
    }

    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInvoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
    }

    public PostPaymentInstructionBankModel expectedBehaviour(ExpectedBehaviourEnum expectedBehaviour) {
        this.expectedBehaviour = expectedBehaviour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected behaviour to simulate.")
    @JsonProperty(value="expected_behaviour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExpectedBehaviourEnum getExpectedBehaviour() {
        return this.expectedBehaviour;
    }

    @JsonProperty(value="expected_behaviour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedBehaviour(ExpectedBehaviourEnum expectedBehaviour) {
        this.expectedBehaviour = expectedBehaviour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostPaymentInstructionBankModel postPaymentInstruction = (PostPaymentInstructionBankModel)o;
        return Objects.equals(this.invoiceGuid, postPaymentInstruction.invoiceGuid) && Objects.equals((Object)this.expectedBehaviour, (Object)postPaymentInstruction.expectedBehaviour);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.invoiceGuid, this.expectedBehaviour});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostPaymentInstructionBankModel {\n");
        sb.append("    invoiceGuid: ").append(this.toIndentedString(this.invoiceGuid)).append("\n");
        sb.append("    expectedBehaviour: ").append(this.toIndentedString((Object)this.expectedBehaviour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedBehaviourEnum {
        INVOICE_PAID_IMMEDIATELY("invoice_paid_immediately");

        private String value;

        private ExpectedBehaviourEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedBehaviourEnum fromValue(String value) {
            for (ExpectedBehaviourEnum b : ExpectedBehaviourEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

