/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for bank modification.")
@JsonPropertyOrder(value={"name", "supported_trading_symbols", "cors_allowed_origins"})
@JsonTypeName(value="PatchBank")
public class PatchBankBankModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<String> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SUPPORTED_TRADING_SYMBOLS = "supported_trading_symbols";
    private JsonNullable<List<String>> supportedTradingSymbols = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CORS_ALLOWED_ORIGINS = "cors_allowed_origins";
    private JsonNullable<List<String>> corsAllowedOrigins = JsonNullable.undefined();

    public PatchBankBankModel name(String name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the bank.")
    @JsonIgnore
    public String getName() {
        return (String)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<String> name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = JsonNullable.of((Object)name);
    }

    public PatchBankBankModel supportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = JsonNullable.of(supportedTradingSymbols);
        return this;
    }

    public PatchBankBankModel addSupportedTradingSymbolsItem(String supportedTradingSymbolsItem) {
        if (this.supportedTradingSymbols == null || !this.supportedTradingSymbols.isPresent()) {
            this.supportedTradingSymbols = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.supportedTradingSymbols.get()).add(supportedTradingSymbolsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trading symbols supported by the bank.")
    @JsonIgnore
    public List<String> getSupportedTradingSymbols() {
        return (List)this.supportedTradingSymbols.orElse(null);
    }

    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getSupportedTradingSymbols_JsonNullable() {
        return this.supportedTradingSymbols;
    }

    @JsonProperty(value="supported_trading_symbols")
    public void setSupportedTradingSymbols_JsonNullable(JsonNullable<List<String>> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
    }

    public void setSupportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = JsonNullable.of(supportedTradingSymbols);
    }

    public PatchBankBankModel corsAllowedOrigins(List<String> corsAllowedOrigins) {
        this.corsAllowedOrigins = JsonNullable.of(corsAllowedOrigins);
        return this;
    }

    public PatchBankBankModel addCorsAllowedOriginsItem(String corsAllowedOriginsItem) {
        if (this.corsAllowedOrigins == null || !this.corsAllowedOrigins.isPresent()) {
            this.corsAllowedOrigins = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.corsAllowedOrigins.get()).add(corsAllowedOriginsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of allowed CORS origin URIs.")
    @JsonIgnore
    public List<String> getCorsAllowedOrigins() {
        return (List)this.corsAllowedOrigins.orElse(null);
    }

    @JsonProperty(value="cors_allowed_origins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getCorsAllowedOrigins_JsonNullable() {
        return this.corsAllowedOrigins;
    }

    @JsonProperty(value="cors_allowed_origins")
    public void setCorsAllowedOrigins_JsonNullable(JsonNullable<List<String>> corsAllowedOrigins) {
        this.corsAllowedOrigins = corsAllowedOrigins;
    }

    public void setCorsAllowedOrigins(List<String> corsAllowedOrigins) {
        this.corsAllowedOrigins = JsonNullable.of(corsAllowedOrigins);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchBankBankModel patchBank = (PatchBankBankModel)o;
        return PatchBankBankModel.equalsNullable(this.name, patchBank.name) && PatchBankBankModel.equalsNullable(this.supportedTradingSymbols, patchBank.supportedTradingSymbols) && PatchBankBankModel.equalsNullable(this.corsAllowedOrigins, patchBank.corsAllowedOrigins);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(PatchBankBankModel.hashCodeNullable(this.name), PatchBankBankModel.hashCodeNullable(this.supportedTradingSymbols), PatchBankBankModel.hashCodeNullable(this.corsAllowedOrigins));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchBankBankModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedTradingSymbols: ").append(this.toIndentedString(this.supportedTradingSymbols)).append("\n");
        sb.append("    corsAllowedOrigins: ").append(this.toIndentedString(this.corsAllowedOrigins)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

