/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"symbol", "buy_price", "sell_price", "buy_price_last_updated_at", "sell_price_last_updated_at"})
@JsonTypeName(value="SymbolPrice")
public class SymbolPriceBankModel {
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_BUY_PRICE = "buy_price";
    private JsonNullable<BigInteger> buyPrice = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SELL_PRICE = "sell_price";
    private JsonNullable<BigInteger> sellPrice = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BUY_PRICE_LAST_UPDATED_AT = "buy_price_last_updated_at";
    private JsonNullable<OffsetDateTime> buyPriceLastUpdatedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SELL_PRICE_LAST_UPDATED_AT = "sell_price_last_updated_at";
    private JsonNullable<OffsetDateTime> sellPriceLastUpdatedAt = JsonNullable.undefined();

    public SymbolPriceBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trade symbol the pricing is related to. Format is asset-counter_asset, e.g., BTC-USD.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public SymbolPriceBankModel buyPrice(BigInteger buyPrice) {
        this.buyPrice = JsonNullable.of((Object)buyPrice);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The purchase price (in base units) for the asset denominated in the counter asset currency.")
    @JsonIgnore
    public BigInteger getBuyPrice() {
        return (BigInteger)this.buyPrice.orElse(null);
    }

    @JsonProperty(value="buy_price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getBuyPrice_JsonNullable() {
        return this.buyPrice;
    }

    @JsonProperty(value="buy_price")
    public void setBuyPrice_JsonNullable(JsonNullable<BigInteger> buyPrice) {
        this.buyPrice = buyPrice;
    }

    public void setBuyPrice(BigInteger buyPrice) {
        this.buyPrice = JsonNullable.of((Object)buyPrice);
    }

    public SymbolPriceBankModel sellPrice(BigInteger sellPrice) {
        this.sellPrice = JsonNullable.of((Object)sellPrice);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sale price (in base units) for the asset denominated in the counter asset currency.")
    @JsonIgnore
    public BigInteger getSellPrice() {
        return (BigInteger)this.sellPrice.orElse(null);
    }

    @JsonProperty(value="sell_price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getSellPrice_JsonNullable() {
        return this.sellPrice;
    }

    @JsonProperty(value="sell_price")
    public void setSellPrice_JsonNullable(JsonNullable<BigInteger> sellPrice) {
        this.sellPrice = sellPrice;
    }

    public void setSellPrice(BigInteger sellPrice) {
        this.sellPrice = JsonNullable.of((Object)sellPrice);
    }

    public SymbolPriceBankModel buyPriceLastUpdatedAt(OffsetDateTime buyPriceLastUpdatedAt) {
        this.buyPriceLastUpdatedAt = JsonNullable.of((Object)buyPriceLastUpdatedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the purchase price was generated at.")
    @JsonIgnore
    public OffsetDateTime getBuyPriceLastUpdatedAt() {
        return (OffsetDateTime)this.buyPriceLastUpdatedAt.orElse(null);
    }

    @JsonProperty(value="buy_price_last_updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getBuyPriceLastUpdatedAt_JsonNullable() {
        return this.buyPriceLastUpdatedAt;
    }

    @JsonProperty(value="buy_price_last_updated_at")
    public void setBuyPriceLastUpdatedAt_JsonNullable(JsonNullable<OffsetDateTime> buyPriceLastUpdatedAt) {
        this.buyPriceLastUpdatedAt = buyPriceLastUpdatedAt;
    }

    public void setBuyPriceLastUpdatedAt(OffsetDateTime buyPriceLastUpdatedAt) {
        this.buyPriceLastUpdatedAt = JsonNullable.of((Object)buyPriceLastUpdatedAt);
    }

    public SymbolPriceBankModel sellPriceLastUpdatedAt(OffsetDateTime sellPriceLastUpdatedAt) {
        this.sellPriceLastUpdatedAt = JsonNullable.of((Object)sellPriceLastUpdatedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the sale price was generated at.")
    @JsonIgnore
    public OffsetDateTime getSellPriceLastUpdatedAt() {
        return (OffsetDateTime)this.sellPriceLastUpdatedAt.orElse(null);
    }

    @JsonProperty(value="sell_price_last_updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getSellPriceLastUpdatedAt_JsonNullable() {
        return this.sellPriceLastUpdatedAt;
    }

    @JsonProperty(value="sell_price_last_updated_at")
    public void setSellPriceLastUpdatedAt_JsonNullable(JsonNullable<OffsetDateTime> sellPriceLastUpdatedAt) {
        this.sellPriceLastUpdatedAt = sellPriceLastUpdatedAt;
    }

    public void setSellPriceLastUpdatedAt(OffsetDateTime sellPriceLastUpdatedAt) {
        this.sellPriceLastUpdatedAt = JsonNullable.of((Object)sellPriceLastUpdatedAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolPriceBankModel symbolPrice = (SymbolPriceBankModel)o;
        return Objects.equals(this.symbol, symbolPrice.symbol) && SymbolPriceBankModel.equalsNullable(this.buyPrice, symbolPrice.buyPrice) && SymbolPriceBankModel.equalsNullable(this.sellPrice, symbolPrice.sellPrice) && SymbolPriceBankModel.equalsNullable(this.buyPriceLastUpdatedAt, symbolPrice.buyPriceLastUpdatedAt) && SymbolPriceBankModel.equalsNullable(this.sellPriceLastUpdatedAt, symbolPrice.sellPriceLastUpdatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.symbol, SymbolPriceBankModel.hashCodeNullable(this.buyPrice), SymbolPriceBankModel.hashCodeNullable(this.sellPrice), SymbolPriceBankModel.hashCodeNullable(this.buyPriceLastUpdatedAt), SymbolPriceBankModel.hashCodeNullable(this.sellPriceLastUpdatedAt));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SymbolPriceBankModel {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    buyPrice: ").append(this.toIndentedString(this.buyPrice)).append("\n");
        sb.append("    sellPrice: ").append(this.toIndentedString(this.sellPrice)).append("\n");
        sb.append("    buyPriceLastUpdatedAt: ").append(this.toIndentedString(this.buyPriceLastUpdatedAt)).append("\n");
        sb.append("    sellPriceLastUpdatedAt: ").append(this.toIndentedString(this.sellPriceLastUpdatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

