/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostIdentificationNumberBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentityVerificationAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentityVerificationNameBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for identity verification creation.")
@JsonPropertyOrder(value={"type", "customer_guid", "expected_behaviours", "method", "counterparty_guid", "country_code", "name", "address", "date_of_birth", "identification_numbers", "external_bank_account_guid", "phone_number", "email_address"})
@JsonTypeName(value="PostIdentityVerification")
public class PostIdentityVerificationBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPECTED_BEHAVIOURS = "expected_behaviours";
    private JsonNullable<List<ExpectedBehavioursEnum>> expectedBehaviours = JsonNullable.undefined();
    public static final String JSON_PROPERTY_METHOD = "method";
    private JsonNullable<MethodEnum> method = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_GUID = "counterparty_guid";
    private JsonNullable<String> counterpartyGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTRY_CODE = "country_code";
    private JsonNullable<String> countryCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<PostIdentityVerificationNameBankModel> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private JsonNullable<PostIdentityVerificationAddressBankModel> address = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private JsonNullable<LocalDate> dateOfBirth = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IDENTIFICATION_NUMBERS = "identification_numbers";
    private JsonNullable<List<PostIdentificationNumberBankModel>> identificationNumbers = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private JsonNullable<String> externalBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private JsonNullable<String> phoneNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private JsonNullable<String> emailAddress = JsonNullable.undefined();

    public PostIdentityVerificationBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of identity verification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostIdentityVerificationBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostIdentityVerificationBankModel expectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = JsonNullable.of(expectedBehaviours);
        return this;
    }

    public PostIdentityVerificationBankModel addExpectedBehavioursItem(ExpectedBehavioursEnum expectedBehavioursItem) {
        if (this.expectedBehaviours == null || !this.expectedBehaviours.isPresent()) {
            this.expectedBehaviours = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.expectedBehaviours.get()).add(expectedBehavioursItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected behaviour to simulate.")
    @JsonIgnore
    public List<ExpectedBehavioursEnum> getExpectedBehaviours() {
        return (List)this.expectedBehaviours.orElse(null);
    }

    @JsonProperty(value="expected_behaviours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<ExpectedBehavioursEnum>> getExpectedBehaviours_JsonNullable() {
        return this.expectedBehaviours;
    }

    @JsonProperty(value="expected_behaviours")
    public void setExpectedBehaviours_JsonNullable(JsonNullable<List<ExpectedBehavioursEnum>> expectedBehaviours) {
        this.expectedBehaviours = expectedBehaviours;
    }

    public void setExpectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = JsonNullable.of(expectedBehaviours);
    }

    public PostIdentityVerificationBankModel method(MethodEnum method) {
        this.method = JsonNullable.of((Object)((Object)method));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification method. Required when type is counterparty, type is kyc, or type is bank_account.")
    @JsonIgnore
    public MethodEnum getMethod() {
        return (MethodEnum)((Object)this.method.orElse(null));
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<MethodEnum> getMethod_JsonNullable() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod_JsonNullable(JsonNullable<MethodEnum> method) {
        this.method = method;
    }

    public void setMethod(MethodEnum method) {
        this.method = JsonNullable.of((Object)((Object)method));
    }

    public PostIdentityVerificationBankModel counterpartyGuid(String counterpartyGuid) {
        this.counterpartyGuid = JsonNullable.of((Object)counterpartyGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's identifier. Required when type is counterparty.")
    @JsonIgnore
    public String getCounterpartyGuid() {
        return (String)this.counterpartyGuid.orElse(null);
    }

    @JsonProperty(value="counterparty_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCounterpartyGuid_JsonNullable() {
        return this.counterpartyGuid;
    }

    @JsonProperty(value="counterparty_guid")
    public void setCounterpartyGuid_JsonNullable(JsonNullable<String> counterpartyGuid) {
        this.counterpartyGuid = counterpartyGuid;
    }

    public void setCounterpartyGuid(String counterpartyGuid) {
        this.counterpartyGuid = JsonNullable.of((Object)counterpartyGuid);
    }

    public PostIdentityVerificationBankModel countryCode(String countryCode) {
        this.countryCode = JsonNullable.of((Object)countryCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166 country 2-Alpha country the customer is being verified in. If not present, will default to the Bank's configured country code. Optional when type is kyc and method is id_and_selfie, type is kyc and method is tax_id_and_selfie, or type is kyc and method is business_registration.")
    @JsonIgnore
    public String getCountryCode() {
        return (String)this.countryCode.orElse(null);
    }

    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCountryCode_JsonNullable() {
        return this.countryCode;
    }

    @JsonProperty(value="country_code")
    public void setCountryCode_JsonNullable(JsonNullable<String> countryCode) {
        this.countryCode = countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = JsonNullable.of((Object)countryCode);
    }

    public PostIdentityVerificationBankModel name(PostIdentityVerificationNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostIdentityVerificationNameBankModel getName() {
        return (PostIdentityVerificationNameBankModel)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostIdentityVerificationNameBankModel> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<PostIdentityVerificationNameBankModel> name) {
        this.name = name;
    }

    public void setName(PostIdentityVerificationNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
    }

    public PostIdentityVerificationBankModel address(PostIdentityVerificationAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostIdentityVerificationAddressBankModel getAddress() {
        return (PostIdentityVerificationAddressBankModel)this.address.orElse(null);
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostIdentityVerificationAddressBankModel> getAddress_JsonNullable() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress_JsonNullable(JsonNullable<PostIdentityVerificationAddressBankModel> address) {
        this.address = address;
    }

    public void setAddress(PostIdentityVerificationAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
    }

    public PostIdentityVerificationBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's date of birth. Required when type is kyc and method is attested.")
    @JsonIgnore
    public LocalDate getDateOfBirth() {
        return (LocalDate)this.dateOfBirth.orElse(null);
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getDateOfBirth_JsonNullable() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    public void setDateOfBirth_JsonNullable(JsonNullable<LocalDate> dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
    }

    public PostIdentityVerificationBankModel identificationNumbers(List<PostIdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = JsonNullable.of(identificationNumbers);
        return this;
    }

    public PostIdentityVerificationBankModel addIdentificationNumbersItem(PostIdentificationNumberBankModel identificationNumbersItem) {
        if (this.identificationNumbers == null || !this.identificationNumbers.isPresent()) {
            this.identificationNumbers = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.identificationNumbers.get()).add(identificationNumbersItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identification numbers. Required when type is kyc and method is attested.")
    @JsonIgnore
    public List<PostIdentificationNumberBankModel> getIdentificationNumbers() {
        return (List)this.identificationNumbers.orElse(null);
    }

    @JsonProperty(value="identification_numbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostIdentificationNumberBankModel>> getIdentificationNumbers_JsonNullable() {
        return this.identificationNumbers;
    }

    @JsonProperty(value="identification_numbers")
    public void setIdentificationNumbers_JsonNullable(JsonNullable<List<PostIdentificationNumberBankModel>> identificationNumbers) {
        this.identificationNumbers = identificationNumbers;
    }

    public void setIdentificationNumbers(List<PostIdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = JsonNullable.of(identificationNumbers);
    }

    public PostIdentityVerificationBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external bank account's identifier. Required when type is bank_account.")
    @JsonIgnore
    public String getExternalBankAccountGuid() {
        return (String)this.externalBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalBankAccountGuid_JsonNullable() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    public void setExternalBankAccountGuid_JsonNullable(JsonNullable<String> externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
    }

    public PostIdentityVerificationBankModel phoneNumber(String phoneNumber) {
        this.phoneNumber = JsonNullable.of((Object)phoneNumber);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's phone number. Optional when type is bank_account and method is attested_ownership.")
    @JsonIgnore
    public String getPhoneNumber() {
        return (String)this.phoneNumber.orElse(null);
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPhoneNumber_JsonNullable() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber_JsonNullable(JsonNullable<String> phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = JsonNullable.of((Object)phoneNumber);
    }

    public PostIdentityVerificationBankModel emailAddress(String emailAddress) {
        this.emailAddress = JsonNullable.of((Object)emailAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's email address. Optional when type is bank_account and method is attested_ownership.")
    @JsonIgnore
    public String getEmailAddress() {
        return (String)this.emailAddress.orElse(null);
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getEmailAddress_JsonNullable() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    public void setEmailAddress_JsonNullable(JsonNullable<String> emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = JsonNullable.of((Object)emailAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostIdentityVerificationBankModel postIdentityVerification = (PostIdentityVerificationBankModel)o;
        return Objects.equals((Object)this.type, (Object)postIdentityVerification.type) && PostIdentityVerificationBankModel.equalsNullable(this.customerGuid, postIdentityVerification.customerGuid) && PostIdentityVerificationBankModel.equalsNullable(this.expectedBehaviours, postIdentityVerification.expectedBehaviours) && PostIdentityVerificationBankModel.equalsNullable(this.method, postIdentityVerification.method) && PostIdentityVerificationBankModel.equalsNullable(this.counterpartyGuid, postIdentityVerification.counterpartyGuid) && PostIdentityVerificationBankModel.equalsNullable(this.countryCode, postIdentityVerification.countryCode) && PostIdentityVerificationBankModel.equalsNullable(this.name, postIdentityVerification.name) && PostIdentityVerificationBankModel.equalsNullable(this.address, postIdentityVerification.address) && PostIdentityVerificationBankModel.equalsNullable(this.dateOfBirth, postIdentityVerification.dateOfBirth) && PostIdentityVerificationBankModel.equalsNullable(this.identificationNumbers, postIdentityVerification.identificationNumbers) && PostIdentityVerificationBankModel.equalsNullable(this.externalBankAccountGuid, postIdentityVerification.externalBankAccountGuid) && PostIdentityVerificationBankModel.equalsNullable(this.phoneNumber, postIdentityVerification.phoneNumber) && PostIdentityVerificationBankModel.equalsNullable(this.emailAddress, postIdentityVerification.emailAddress);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, PostIdentityVerificationBankModel.hashCodeNullable(this.customerGuid), PostIdentityVerificationBankModel.hashCodeNullable(this.expectedBehaviours), PostIdentityVerificationBankModel.hashCodeNullable(this.method), PostIdentityVerificationBankModel.hashCodeNullable(this.counterpartyGuid), PostIdentityVerificationBankModel.hashCodeNullable(this.countryCode), PostIdentityVerificationBankModel.hashCodeNullable(this.name), PostIdentityVerificationBankModel.hashCodeNullable(this.address), PostIdentityVerificationBankModel.hashCodeNullable(this.dateOfBirth), PostIdentityVerificationBankModel.hashCodeNullable(this.identificationNumbers), PostIdentityVerificationBankModel.hashCodeNullable(this.externalBankAccountGuid), PostIdentityVerificationBankModel.hashCodeNullable(this.phoneNumber), PostIdentityVerificationBankModel.hashCodeNullable(this.emailAddress)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostIdentityVerificationBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    expectedBehaviours: ").append(this.toIndentedString(this.expectedBehaviours)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    counterpartyGuid: ").append(this.toIndentedString(this.counterpartyGuid)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    identificationNumbers: ").append(this.toIndentedString(this.identificationNumbers)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MethodEnum {
        WATCHLISTS("watchlists"),
        ATTESTED("attested"),
        DOCUMENT_SUBMISSION("document_submission"),
        ID_AND_SELFIE("id_and_selfie"),
        TAX_ID_AND_SELFIE("tax_id_and_selfie"),
        BUSINESS_REGISTRATION("business_registration"),
        ATTESTED_OWNERSHIP("attested_ownership"),
        ACCOUNT_OWNERSHIP("account_ownership");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ExpectedBehavioursEnum {
        PASSED_IMMEDIATELY("passed_immediately"),
        FAILED_IMMEDIATELY("failed_immediately"),
        TAX_ID_NOT_CHECKED("tax_id_not_checked");

        private String value;

        private ExpectedBehavioursEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedBehavioursEnum fromValue(String value) {
            for (ExpectedBehavioursEnum b : ExpectedBehavioursEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        KYC("kyc"),
        BANK_ACCOUNT("bank_account"),
        COUNTERPARTY("counterparty");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

