/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for bank creation.")
@JsonPropertyOrder(value={"type", "name", "supported_trading_symbols", "supported_payout_symbols", "supported_fiat_account_assets", "supported_country_codes", "features", "cors_allowed_origins"})
@JsonTypeName(value="PostBank")
public class PostBankBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SUPPORTED_TRADING_SYMBOLS = "supported_trading_symbols";
    private List<String> supportedTradingSymbols = new ArrayList<String>();
    public static final String JSON_PROPERTY_SUPPORTED_PAYOUT_SYMBOLS = "supported_payout_symbols";
    private JsonNullable<List<Object>> supportedPayoutSymbols = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SUPPORTED_FIAT_ACCOUNT_ASSETS = "supported_fiat_account_assets";
    private List<String> supportedFiatAccountAssets = new ArrayList<String>();
    public static final String JSON_PROPERTY_SUPPORTED_COUNTRY_CODES = "supported_country_codes";
    private List<String> supportedCountryCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<FeaturesEnum> features = new ArrayList<FeaturesEnum>();
    public static final String JSON_PROPERTY_CORS_ALLOWED_ORIGINS = "cors_allowed_origins";
    private JsonNullable<List<String>> corsAllowedOrigins = JsonNullable.undefined();

    public PostBankBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of bank.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostBankBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the bank.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PostBankBankModel supportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
        return this;
    }

    public PostBankBankModel addSupportedTradingSymbolsItem(String supportedTradingSymbolsItem) {
        this.supportedTradingSymbols.add(supportedTradingSymbolsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The trading symbols supported by the bank.")
    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSupportedTradingSymbols() {
        return this.supportedTradingSymbols;
    }

    @JsonProperty(value="supported_trading_symbols")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedTradingSymbols(List<String> supportedTradingSymbols) {
        this.supportedTradingSymbols = supportedTradingSymbols;
    }

    public PostBankBankModel supportedPayoutSymbols(List<Object> supportedPayoutSymbols) {
        this.supportedPayoutSymbols = JsonNullable.of(supportedPayoutSymbols);
        return this;
    }

    public PostBankBankModel addSupportedPayoutSymbolsItem(Object supportedPayoutSymbolsItem) {
        if (this.supportedPayoutSymbols == null || !this.supportedPayoutSymbols.isPresent()) {
            this.supportedPayoutSymbols = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.supportedPayoutSymbols.get()).add(supportedPayoutSymbolsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payout symbols supported by the bank. This is not yet supported and should be nil or empty.")
    @JsonIgnore
    public List<Object> getSupportedPayoutSymbols() {
        return (List)this.supportedPayoutSymbols.orElse(null);
    }

    @JsonProperty(value="supported_payout_symbols")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<Object>> getSupportedPayoutSymbols_JsonNullable() {
        return this.supportedPayoutSymbols;
    }

    @JsonProperty(value="supported_payout_symbols")
    public void setSupportedPayoutSymbols_JsonNullable(JsonNullable<List<Object>> supportedPayoutSymbols) {
        this.supportedPayoutSymbols = supportedPayoutSymbols;
    }

    public void setSupportedPayoutSymbols(List<Object> supportedPayoutSymbols) {
        this.supportedPayoutSymbols = JsonNullable.of(supportedPayoutSymbols);
    }

    public PostBankBankModel supportedFiatAccountAssets(List<String> supportedFiatAccountAssets) {
        this.supportedFiatAccountAssets = supportedFiatAccountAssets;
        return this;
    }

    public PostBankBankModel addSupportedFiatAccountAssetsItem(String supportedFiatAccountAssetsItem) {
        this.supportedFiatAccountAssets.add(supportedFiatAccountAssetsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fiat account assets supported by the bank.")
    @JsonProperty(value="supported_fiat_account_assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSupportedFiatAccountAssets() {
        return this.supportedFiatAccountAssets;
    }

    @JsonProperty(value="supported_fiat_account_assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedFiatAccountAssets(List<String> supportedFiatAccountAssets) {
        this.supportedFiatAccountAssets = supportedFiatAccountAssets;
    }

    public PostBankBankModel supportedCountryCodes(List<String> supportedCountryCodes) {
        this.supportedCountryCodes = supportedCountryCodes;
        return this;
    }

    public PostBankBankModel addSupportedCountryCodesItem(String supportedCountryCodesItem) {
        this.supportedCountryCodes.add(supportedCountryCodesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The country codes supported by the bank.")
    @JsonProperty(value="supported_country_codes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSupportedCountryCodes() {
        return this.supportedCountryCodes;
    }

    @JsonProperty(value="supported_country_codes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedCountryCodes(List<String> supportedCountryCodes) {
        this.supportedCountryCodes = supportedCountryCodes;
    }

    public PostBankBankModel features(List<FeaturesEnum> features) {
        this.features = features;
        return this;
    }

    public PostBankBankModel addFeaturesItem(FeaturesEnum featuresItem) {
        this.features.add(featuresItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The features supported by the bank.")
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FeaturesEnum> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeatures(List<FeaturesEnum> features) {
        this.features = features;
    }

    public PostBankBankModel corsAllowedOrigins(List<String> corsAllowedOrigins) {
        this.corsAllowedOrigins = JsonNullable.of(corsAllowedOrigins);
        return this;
    }

    public PostBankBankModel addCorsAllowedOriginsItem(String corsAllowedOriginsItem) {
        if (this.corsAllowedOrigins == null || !this.corsAllowedOrigins.isPresent()) {
            this.corsAllowedOrigins = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.corsAllowedOrigins.get()).add(corsAllowedOriginsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of allowed CORS origin URIs.")
    @JsonIgnore
    public List<String> getCorsAllowedOrigins() {
        return (List)this.corsAllowedOrigins.orElse(null);
    }

    @JsonProperty(value="cors_allowed_origins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getCorsAllowedOrigins_JsonNullable() {
        return this.corsAllowedOrigins;
    }

    @JsonProperty(value="cors_allowed_origins")
    public void setCorsAllowedOrigins_JsonNullable(JsonNullable<List<String>> corsAllowedOrigins) {
        this.corsAllowedOrigins = corsAllowedOrigins;
    }

    public void setCorsAllowedOrigins(List<String> corsAllowedOrigins) {
        this.corsAllowedOrigins = JsonNullable.of(corsAllowedOrigins);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostBankBankModel postBank = (PostBankBankModel)o;
        return Objects.equals((Object)this.type, (Object)postBank.type) && Objects.equals(this.name, postBank.name) && Objects.equals(this.supportedTradingSymbols, postBank.supportedTradingSymbols) && PostBankBankModel.equalsNullable(this.supportedPayoutSymbols, postBank.supportedPayoutSymbols) && Objects.equals(this.supportedFiatAccountAssets, postBank.supportedFiatAccountAssets) && Objects.equals(this.supportedCountryCodes, postBank.supportedCountryCodes) && Objects.equals(this.features, postBank.features) && PostBankBankModel.equalsNullable(this.corsAllowedOrigins, postBank.corsAllowedOrigins);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.supportedTradingSymbols, PostBankBankModel.hashCodeNullable(this.supportedPayoutSymbols), this.supportedFiatAccountAssets, this.supportedCountryCodes, this.features, PostBankBankModel.hashCodeNullable(this.corsAllowedOrigins)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostBankBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedTradingSymbols: ").append(this.toIndentedString(this.supportedTradingSymbols)).append("\n");
        sb.append("    supportedPayoutSymbols: ").append(this.toIndentedString(this.supportedPayoutSymbols)).append("\n");
        sb.append("    supportedFiatAccountAssets: ").append(this.toIndentedString(this.supportedFiatAccountAssets)).append("\n");
        sb.append("    supportedCountryCodes: ").append(this.toIndentedString(this.supportedCountryCodes)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    corsAllowedOrigins: ").append(this.toIndentedString(this.corsAllowedOrigins)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeaturesEnum {
        ATTESTATION_IDENTITY_RECORDS("attestation_identity_records"),
        ATTESTATION_IDENTITY_RECORDS_V2("attestation_identity_records_v2"),
        KYC_IDENTITY_VERIFICATIONS("kyc_identity_verifications"),
        BUSINESS_CUSTOMERS("business_customers"),
        INDIVIDUAL_CUSTOMERS("individual_customers");

        private String value;

        private FeaturesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeaturesEnum fromValue(String value) {
            for (FeaturesEnum b : FeaturesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        SANDBOX("sandbox");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

