/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "file_type", "content_type", "completed_at", "failed_at", "state", "failure_code"})
@JsonTypeName(value="PlatformFile")
public class PlatformFileBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_FILE_TYPE = "file_type";
    private FileTypeEnum fileType;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "content_type";
    private ContentTypeEnum contentType;
    public static final String JSON_PROPERTY_COMPLETED_AT = "completed_at";
    private OffsetDateTime completedAt;
    public static final String JSON_PROPERTY_FAILED_AT = "failed_at";
    private OffsetDateTime failedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private JsonNullable<String> failureCode = JsonNullable.undefined();

    public PlatformFileBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the file.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public PlatformFileBankModel fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file type; one of drivers_license_front, drivers_license_back, passport, identification_card, residence_card, selfie, selfie_left, selfie_right, utility_bill, bank_statement, property_tax, tax_document, ein_letter, or incorporation_certificate.")
    @JsonProperty(value="file_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    @JsonProperty(value="file_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public PlatformFileBankModel contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The media type; one of image/jpeg, image/png, or application/pdf.")
    @JsonProperty(value="content_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public PlatformFileBankModel completedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO8601 datetime the file was completed at.")
    @JsonProperty(value="completed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    @JsonProperty(value="completed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public PlatformFileBankModel failedAt(OffsetDateTime failedAt) {
        this.failedAt = failedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO8601 datetime the file failed at.")
    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getFailedAt() {
        return this.failedAt;
    }

    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedAt(OffsetDateTime failedAt) {
        this.failedAt = failedAt;
    }

    public PlatformFileBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the file. One of storing, completed, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public PlatformFileBankModel failureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed files.")
    @JsonIgnore
    public String getFailureCode() {
        return (String)this.failureCode.orElse(null);
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFailureCode_JsonNullable() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    public void setFailureCode_JsonNullable(JsonNullable<String> failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFileBankModel platformFile = (PlatformFileBankModel)o;
        return Objects.equals(this.guid, platformFile.guid) && Objects.equals((Object)this.fileType, (Object)platformFile.fileType) && Objects.equals((Object)this.contentType, (Object)platformFile.contentType) && Objects.equals(this.completedAt, platformFile.completedAt) && Objects.equals(this.failedAt, platformFile.failedAt) && Objects.equals((Object)this.state, (Object)platformFile.state) && PlatformFileBankModel.equalsNullable(this.failureCode, platformFile.failureCode);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.fileType, this.contentType, this.completedAt, this.failedAt, this.state, PlatformFileBankModel.hashCodeNullable(this.failureCode)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlatformFileBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    failedAt: ").append(this.toIndentedString(this.failedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        COMPLETED("completed"),
        FAILED("failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ContentTypeEnum {
        IMAGE_JPEG("image/jpeg"),
        IMAGE_PNG("image/png"),
        APPLICATION_PDF("application/pdf");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FileTypeEnum {
        DRIVERS_LICENSE_FRONT("drivers_license_front"),
        DRIVERS_LICENSE_BACK("drivers_license_back"),
        PASSPORT("passport"),
        IDENTIFICATION_CARD("identification_card"),
        RESIDENCE_CARD("residence_card"),
        SELFIE("selfie"),
        SELFIE_LEFT("selfie_left"),
        SELFIE_RIGHT("selfie_right"),
        UTILITY_BILL("utility_bill"),
        BANK_STATEMENT("bank_statement"),
        PROPERTY_TAX("property_tax"),
        TAX_DOCUMENT("tax_document"),
        EIN_LETTER("ein_letter"),
        INCORPORATION_CERTIFICATE("incorporation_certificate");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileTypeEnum fromValue(String value) {
            for (FileTypeEnum b : FileTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

