/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostCustomerAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostCustomerAliasesInnerBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostCustomerNameBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentificationNumberBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for customer creation.")
@JsonPropertyOrder(value={"type", "address", "phone_number", "email_address", "identification_numbers", "name", "date_of_birth", "aliases", "website", "labels"})
@JsonTypeName(value="PostCustomer")
public class PostCustomerBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private JsonNullable<PostCustomerAddressBankModel> address = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private JsonNullable<String> phoneNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private JsonNullable<String> emailAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IDENTIFICATION_NUMBERS = "identification_numbers";
    private JsonNullable<List<PostIdentificationNumberBankModel>> identificationNumbers = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<PostCustomerNameBankModel> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private JsonNullable<LocalDate> dateOfBirth = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private JsonNullable<List<PostCustomerAliasesInnerBankModel>> aliases = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WEBSITE = "website";
    private JsonNullable<String> website = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostCustomerBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of customer.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostCustomerBankModel address(PostCustomerAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostCustomerAddressBankModel getAddress() {
        return (PostCustomerAddressBankModel)this.address.orElse(null);
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostCustomerAddressBankModel> getAddress_JsonNullable() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress_JsonNullable(JsonNullable<PostCustomerAddressBankModel> address) {
        this.address = address;
    }

    public void setAddress(PostCustomerAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
    }

    public PostCustomerBankModel phoneNumber(String phoneNumber) {
        this.phoneNumber = JsonNullable.of((Object)phoneNumber);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's phone number.")
    @JsonIgnore
    public String getPhoneNumber() {
        return (String)this.phoneNumber.orElse(null);
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPhoneNumber_JsonNullable() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber_JsonNullable(JsonNullable<String> phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = JsonNullable.of((Object)phoneNumber);
    }

    public PostCustomerBankModel emailAddress(String emailAddress) {
        this.emailAddress = JsonNullable.of((Object)emailAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's email address.")
    @JsonIgnore
    public String getEmailAddress() {
        return (String)this.emailAddress.orElse(null);
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getEmailAddress_JsonNullable() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    public void setEmailAddress_JsonNullable(JsonNullable<String> emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = JsonNullable.of((Object)emailAddress);
    }

    public PostCustomerBankModel identificationNumbers(List<PostIdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = JsonNullable.of(identificationNumbers);
        return this;
    }

    public PostCustomerBankModel addIdentificationNumbersItem(PostIdentificationNumberBankModel identificationNumbersItem) {
        if (this.identificationNumbers == null || !this.identificationNumbers.isPresent()) {
            this.identificationNumbers = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.identificationNumbers.get()).add(identificationNumbersItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identification numbers.")
    @JsonIgnore
    public List<PostIdentificationNumberBankModel> getIdentificationNumbers() {
        return (List)this.identificationNumbers.orElse(null);
    }

    @JsonProperty(value="identification_numbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostIdentificationNumberBankModel>> getIdentificationNumbers_JsonNullable() {
        return this.identificationNumbers;
    }

    @JsonProperty(value="identification_numbers")
    public void setIdentificationNumbers_JsonNullable(JsonNullable<List<PostIdentificationNumberBankModel>> identificationNumbers) {
        this.identificationNumbers = identificationNumbers;
    }

    public void setIdentificationNumbers(List<PostIdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = JsonNullable.of(identificationNumbers);
    }

    public PostCustomerBankModel name(PostCustomerNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostCustomerNameBankModel getName() {
        return (PostCustomerNameBankModel)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostCustomerNameBankModel> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<PostCustomerNameBankModel> name) {
        this.name = name;
    }

    public void setName(PostCustomerNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
    }

    public PostCustomerBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's date of birth. Optional when type is individual.")
    @JsonIgnore
    public LocalDate getDateOfBirth() {
        return (LocalDate)this.dateOfBirth.orElse(null);
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getDateOfBirth_JsonNullable() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    public void setDateOfBirth_JsonNullable(JsonNullable<LocalDate> dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
    }

    public PostCustomerBankModel aliases(List<PostCustomerAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
        return this;
    }

    public PostCustomerBankModel addAliasesItem(PostCustomerAliasesInnerBankModel aliasesItem) {
        if (this.aliases == null || !this.aliases.isPresent()) {
            this.aliases = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.aliases.get()).add(aliasesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The aliases of the customer. Optional when type is business.")
    @JsonIgnore
    public List<PostCustomerAliasesInnerBankModel> getAliases() {
        return (List)this.aliases.orElse(null);
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostCustomerAliasesInnerBankModel>> getAliases_JsonNullable() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    public void setAliases_JsonNullable(JsonNullable<List<PostCustomerAliasesInnerBankModel>> aliases) {
        this.aliases = aliases;
    }

    public void setAliases(List<PostCustomerAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
    }

    public PostCustomerBankModel website(String website) {
        this.website = JsonNullable.of((Object)website);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's website. Optional when type is business.")
    @JsonIgnore
    public String getWebsite() {
        return (String)this.website.orElse(null);
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getWebsite_JsonNullable() {
        return this.website;
    }

    @JsonProperty(value="website")
    public void setWebsite_JsonNullable(JsonNullable<String> website) {
        this.website = website;
    }

    public void setWebsite(String website) {
        this.website = JsonNullable.of((Object)website);
    }

    public PostCustomerBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostCustomerBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the customer.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostCustomerBankModel postCustomer = (PostCustomerBankModel)o;
        return Objects.equals((Object)this.type, (Object)postCustomer.type) && PostCustomerBankModel.equalsNullable(this.address, postCustomer.address) && PostCustomerBankModel.equalsNullable(this.phoneNumber, postCustomer.phoneNumber) && PostCustomerBankModel.equalsNullable(this.emailAddress, postCustomer.emailAddress) && PostCustomerBankModel.equalsNullable(this.identificationNumbers, postCustomer.identificationNumbers) && PostCustomerBankModel.equalsNullable(this.name, postCustomer.name) && PostCustomerBankModel.equalsNullable(this.dateOfBirth, postCustomer.dateOfBirth) && PostCustomerBankModel.equalsNullable(this.aliases, postCustomer.aliases) && PostCustomerBankModel.equalsNullable(this.website, postCustomer.website) && PostCustomerBankModel.equalsNullable(this.labels, postCustomer.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, PostCustomerBankModel.hashCodeNullable(this.address), PostCustomerBankModel.hashCodeNullable(this.phoneNumber), PostCustomerBankModel.hashCodeNullable(this.emailAddress), PostCustomerBankModel.hashCodeNullable(this.identificationNumbers), PostCustomerBankModel.hashCodeNullable(this.name), PostCustomerBankModel.hashCodeNullable(this.dateOfBirth), PostCustomerBankModel.hashCodeNullable(this.aliases), PostCustomerBankModel.hashCodeNullable(this.website), PostCustomerBankModel.hashCodeNullable(this.labels)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostCustomerBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    identificationNumbers: ").append(this.toIndentedString(this.identificationNumbers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BUSINESS("business"),
        INDIVIDUAL("individual");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

