/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PlatformFileBankModel;
import app.cybrid.cybrid_api_bank.client.model.PlatformFileListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostFileBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class FilesBankApi {
    private ApiClient apiClient;

    public FilesBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public FilesBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createFileRequestCreation(PostFileBankModel postFileBankModel) throws WebClientResponseException {
        PostFileBankModel postBody = postFileBankModel;
        if (postFileBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postFileBankModel' when calling createFile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<PlatformFileBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileBankModel>(){};
        return this.apiClient.invokeAPI("/api/files", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PlatformFileBankModel> createFile(PostFileBankModel postFileBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<PlatformFileBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileBankModel>(){};
        return this.createFileRequestCreation(postFileBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PlatformFileBankModel>> createFileWithHttpInfo(PostFileBankModel postFileBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<PlatformFileBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileBankModel>(){};
        return this.createFileRequestCreation(postFileBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getFileRequestCreation(String fileGuid) throws WebClientResponseException {
        Object postBody = null;
        if (fileGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'fileGuid' when calling getFile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("file_guid", fileGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<PlatformFileBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileBankModel>(){};
        return this.apiClient.invokeAPI("/api/files/{file_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PlatformFileBankModel> getFile(String fileGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PlatformFileBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileBankModel>(){};
        return this.getFileRequestCreation(fileGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PlatformFileBankModel>> getFileWithHttpInfo(String fileGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PlatformFileBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileBankModel>(){};
        return this.getFileRequestCreation(fileGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listFilesRequestCreation(BigInteger page, BigInteger perPage, String guid, String type, String state, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<PlatformFileListBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileListBankModel>(){};
        return this.apiClient.invokeAPI("/api/files", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PlatformFileListBankModel> listFiles(BigInteger page, BigInteger perPage, String guid, String type, String state, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PlatformFileListBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileListBankModel>(){};
        return this.listFilesRequestCreation(page, perPage, guid, type, state, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PlatformFileListBankModel>> listFilesWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String type, String state, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PlatformFileListBankModel> localVarReturnType = new ParameterizedTypeReference<PlatformFileListBankModel>(){};
        return this.listFilesRequestCreation(page, perPage, guid, type, state, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

