/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "asset", "amount", "interval", "activities"})
@JsonTypeName(value="ActivityLimit")
public class ActivityLimitBankModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private BigInteger interval;
    public static final String JSON_PROPERTY_ACTIVITIES = "activities";
    private List<String> activities = null;

    public ActivityLimitBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the limit.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ActivityLimitBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code for the limit.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public ActivityLimitBankModel amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The limit amount for the asset.")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public ActivityLimitBankModel interval(BigInteger interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The limit interval in seconds for the asset.")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterval(BigInteger interval) {
        this.interval = interval;
    }

    public ActivityLimitBankModel activities(List<String> activities) {
        this.activities = activities;
        return this;
    }

    public ActivityLimitBankModel addActivitiesItem(String activitiesItem) {
        if (this.activities == null) {
            this.activities = new ArrayList<String>();
        }
        this.activities.add(activitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The activities associated with the limit.")
    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getActivities() {
        return this.activities;
    }

    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivities(List<String> activities) {
        this.activities = activities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityLimitBankModel activityLimit = (ActivityLimitBankModel)o;
        return Objects.equals(this.name, activityLimit.name) && Objects.equals(this.asset, activityLimit.asset) && Objects.equals(this.amount, activityLimit.amount) && Objects.equals(this.interval, activityLimit.interval) && Objects.equals(this.activities, activityLimit.activities);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.asset, this.amount, this.interval, this.activities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityLimitBankModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

