/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "bank_guid", "customer_guid", "type", "state", "failure_code", "created_at", "updated_at", "plaid_link_token"})
@JsonTypeName(value="WorkflowWithDetails")
public class WorkflowWithDetailsBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private JsonNullable<String> bankGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private JsonNullable<String> failureCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_PLAID_LINK_TOKEN = "plaid_link_token";
    private JsonNullable<String> plaidLinkToken = JsonNullable.undefined();

    public WorkflowWithDetailsBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the workflow.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public WorkflowWithDetailsBankModel bankGuid(String bankGuid) {
        this.bankGuid = JsonNullable.of((Object)bankGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated banks's identifier.")
    @JsonIgnore
    public String getBankGuid() {
        return (String)this.bankGuid.orElse(null);
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBankGuid_JsonNullable() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    public void setBankGuid_JsonNullable(JsonNullable<String> bankGuid) {
        this.bankGuid = bankGuid;
    }

    public void setBankGuid(String bankGuid) {
        this.bankGuid = JsonNullable.of((Object)bankGuid);
    }

    public WorkflowWithDetailsBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated customer's identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public WorkflowWithDetailsBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of workflow; one of plaid.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public WorkflowWithDetailsBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the workflow; one of storing, completed, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public WorkflowWithDetailsBankModel failureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed workflows.")
    @JsonIgnore
    public String getFailureCode() {
        return (String)this.failureCode.orElse(null);
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFailureCode_JsonNullable() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    public void setFailureCode_JsonNullable(JsonNullable<String> failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
    }

    public WorkflowWithDetailsBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public WorkflowWithDetailsBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public WorkflowWithDetailsBankModel plaidLinkToken(String plaidLinkToken) {
        this.plaidLinkToken = JsonNullable.of((Object)plaidLinkToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid link token generated by the workflow.")
    @JsonIgnore
    public String getPlaidLinkToken() {
        return (String)this.plaidLinkToken.orElse(null);
    }

    @JsonProperty(value="plaid_link_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidLinkToken_JsonNullable() {
        return this.plaidLinkToken;
    }

    @JsonProperty(value="plaid_link_token")
    public void setPlaidLinkToken_JsonNullable(JsonNullable<String> plaidLinkToken) {
        this.plaidLinkToken = plaidLinkToken;
    }

    public void setPlaidLinkToken(String plaidLinkToken) {
        this.plaidLinkToken = JsonNullable.of((Object)plaidLinkToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowWithDetailsBankModel workflowWithDetails = (WorkflowWithDetailsBankModel)o;
        return Objects.equals(this.guid, workflowWithDetails.guid) && WorkflowWithDetailsBankModel.equalsNullable(this.bankGuid, workflowWithDetails.bankGuid) && WorkflowWithDetailsBankModel.equalsNullable(this.customerGuid, workflowWithDetails.customerGuid) && Objects.equals(this.type, workflowWithDetails.type) && Objects.equals(this.state, workflowWithDetails.state) && WorkflowWithDetailsBankModel.equalsNullable(this.failureCode, workflowWithDetails.failureCode) && Objects.equals(this.createdAt, workflowWithDetails.createdAt) && Objects.equals(this.updatedAt, workflowWithDetails.updatedAt) && WorkflowWithDetailsBankModel.equalsNullable(this.plaidLinkToken, workflowWithDetails.plaidLinkToken);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, WorkflowWithDetailsBankModel.hashCodeNullable(this.bankGuid), WorkflowWithDetailsBankModel.hashCodeNullable(this.customerGuid), this.type, this.state, WorkflowWithDetailsBankModel.hashCodeNullable(this.failureCode), this.createdAt, this.updatedAt, WorkflowWithDetailsBankModel.hashCodeNullable(this.plaidLinkToken));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowWithDetailsBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    plaidLinkToken: ").append(this.toIndentedString(this.plaidLinkToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

