/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.ActivityLimitBankModel;
import app.cybrid.cybrid_api_bank.client.model.ComplianceDecisionBankModel;
import app.cybrid.cybrid_api_bank.client.model.CustomerAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.CustomerAliasesInnerBankModel;
import app.cybrid.cybrid_api_bank.client.model.CustomerNameBankModel;
import app.cybrid.cybrid_api_bank.client.model.IdentificationNumberBankModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "bank_guid", "type", "created_at", "updated_at", "state", "name", "address", "aliases", "website", "date_of_birth", "phone_number", "email_address", "labels", "compliance_decisions", "identification_numbers", "activity_limits"})
@JsonTypeName(value="Customer")
public class CustomerBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<CustomerNameBankModel> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private JsonNullable<CustomerAddressBankModel> address = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private JsonNullable<List<CustomerAliasesInnerBankModel>> aliases = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WEBSITE = "website";
    private JsonNullable<String> website = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private JsonNullable<LocalDate> dateOfBirth = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private JsonNullable<String> phoneNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private JsonNullable<String> emailAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COMPLIANCE_DECISIONS = "compliance_decisions";
    private List<ComplianceDecisionBankModel> complianceDecisions = null;
    public static final String JSON_PROPERTY_IDENTIFICATION_NUMBERS = "identification_numbers";
    private JsonNullable<List<IdentificationNumberBankModel>> identificationNumbers = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACTIVITY_LIMITS = "activity_limits";
    private List<ActivityLimitBankModel> activityLimits = null;

    public CustomerBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the customer.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public CustomerBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the customer's bank.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public CustomerBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer type; one of business or individual.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public CustomerBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public CustomerBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public CustomerBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer state; one of storing, unverified, verified, rejected, or frozen.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public CustomerBankModel name(CustomerNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public CustomerNameBankModel getName() {
        return (CustomerNameBankModel)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CustomerNameBankModel> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<CustomerNameBankModel> name) {
        this.name = name;
    }

    public void setName(CustomerNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
    }

    public CustomerBankModel address(CustomerAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public CustomerAddressBankModel getAddress() {
        return (CustomerAddressBankModel)this.address.orElse(null);
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CustomerAddressBankModel> getAddress_JsonNullable() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress_JsonNullable(JsonNullable<CustomerAddressBankModel> address) {
        this.address = address;
    }

    public void setAddress(CustomerAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
    }

    public CustomerBankModel aliases(List<CustomerAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
        return this;
    }

    public CustomerBankModel addAliasesItem(CustomerAliasesInnerBankModel aliasesItem) {
        if (this.aliases == null || !this.aliases.isPresent()) {
            this.aliases = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.aliases.get()).add(aliasesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's aliases. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public List<CustomerAliasesInnerBankModel> getAliases() {
        return (List)this.aliases.orElse(null);
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<CustomerAliasesInnerBankModel>> getAliases_JsonNullable() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    public void setAliases_JsonNullable(JsonNullable<List<CustomerAliasesInnerBankModel>> aliases) {
        this.aliases = aliases;
    }

    public void setAliases(List<CustomerAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
    }

    public CustomerBankModel website(String website) {
        this.website = JsonNullable.of((Object)website);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's website. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public String getWebsite() {
        return (String)this.website.orElse(null);
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getWebsite_JsonNullable() {
        return this.website;
    }

    @JsonProperty(value="website")
    public void setWebsite_JsonNullable(JsonNullable<String> website) {
        this.website = website;
    }

    public void setWebsite(String website) {
        this.website = JsonNullable.of((Object)website);
    }

    public CustomerBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's DOB. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public LocalDate getDateOfBirth() {
        return (LocalDate)this.dateOfBirth.orElse(null);
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getDateOfBirth_JsonNullable() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    public void setDateOfBirth_JsonNullable(JsonNullable<LocalDate> dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
    }

    public CustomerBankModel phoneNumber(String phoneNumber) {
        this.phoneNumber = JsonNullable.of((Object)phoneNumber);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's phone number. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public String getPhoneNumber() {
        return (String)this.phoneNumber.orElse(null);
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPhoneNumber_JsonNullable() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber_JsonNullable(JsonNullable<String> phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = JsonNullable.of((Object)phoneNumber);
    }

    public CustomerBankModel emailAddress(String emailAddress) {
        this.emailAddress = JsonNullable.of((Object)emailAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's email address. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public String getEmailAddress() {
        return (String)this.emailAddress.orElse(null);
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getEmailAddress_JsonNullable() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    public void setEmailAddress_JsonNullable(JsonNullable<String> emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = JsonNullable.of((Object)emailAddress);
    }

    public CustomerBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public CustomerBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the customer.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public CustomerBankModel complianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
        return this;
    }

    public CustomerBankModel addComplianceDecisionsItem(ComplianceDecisionBankModel complianceDecisionsItem) {
        if (this.complianceDecisions == null) {
            this.complianceDecisions = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.complianceDecisions.add(complianceDecisionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The compliance decisions associated with the customer.")
    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getComplianceDecisions() {
        return this.complianceDecisions;
    }

    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComplianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
    }

    public CustomerBankModel identificationNumbers(List<IdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = JsonNullable.of(identificationNumbers);
        return this;
    }

    public CustomerBankModel addIdentificationNumbersItem(IdentificationNumberBankModel identificationNumbersItem) {
        if (this.identificationNumbers == null || !this.identificationNumbers.isPresent()) {
            this.identificationNumbers = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.identificationNumbers.get()).add(identificationNumbersItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identification numbers. Only available for GET operations when 'include_pii' is set and bank has access.")
    @JsonIgnore
    public List<IdentificationNumberBankModel> getIdentificationNumbers() {
        return (List)this.identificationNumbers.orElse(null);
    }

    @JsonProperty(value="identification_numbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<IdentificationNumberBankModel>> getIdentificationNumbers_JsonNullable() {
        return this.identificationNumbers;
    }

    @JsonProperty(value="identification_numbers")
    public void setIdentificationNumbers_JsonNullable(JsonNullable<List<IdentificationNumberBankModel>> identificationNumbers) {
        this.identificationNumbers = identificationNumbers;
    }

    public void setIdentificationNumbers(List<IdentificationNumberBankModel> identificationNumbers) {
        this.identificationNumbers = JsonNullable.of(identificationNumbers);
    }

    public CustomerBankModel activityLimits(List<ActivityLimitBankModel> activityLimits) {
        this.activityLimits = activityLimits;
        return this;
    }

    public CustomerBankModel addActivityLimitsItem(ActivityLimitBankModel activityLimitsItem) {
        if (this.activityLimits == null) {
            this.activityLimits = new ArrayList<ActivityLimitBankModel>();
        }
        this.activityLimits.add(activityLimitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset limits associated with the customer.")
    @JsonProperty(value="activity_limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ActivityLimitBankModel> getActivityLimits() {
        return this.activityLimits;
    }

    @JsonProperty(value="activity_limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivityLimits(List<ActivityLimitBankModel> activityLimits) {
        this.activityLimits = activityLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerBankModel customer = (CustomerBankModel)o;
        return Objects.equals(this.guid, customer.guid) && Objects.equals(this.bankGuid, customer.bankGuid) && Objects.equals(this.type, customer.type) && Objects.equals(this.createdAt, customer.createdAt) && Objects.equals(this.updatedAt, customer.updatedAt) && Objects.equals(this.state, customer.state) && CustomerBankModel.equalsNullable(this.name, customer.name) && CustomerBankModel.equalsNullable(this.address, customer.address) && CustomerBankModel.equalsNullable(this.aliases, customer.aliases) && CustomerBankModel.equalsNullable(this.website, customer.website) && CustomerBankModel.equalsNullable(this.dateOfBirth, customer.dateOfBirth) && CustomerBankModel.equalsNullable(this.phoneNumber, customer.phoneNumber) && CustomerBankModel.equalsNullable(this.emailAddress, customer.emailAddress) && CustomerBankModel.equalsNullable(this.labels, customer.labels) && Objects.equals(this.complianceDecisions, customer.complianceDecisions) && CustomerBankModel.equalsNullable(this.identificationNumbers, customer.identificationNumbers) && Objects.equals(this.activityLimits, customer.activityLimits);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.bankGuid, this.type, this.createdAt, this.updatedAt, this.state, CustomerBankModel.hashCodeNullable(this.name), CustomerBankModel.hashCodeNullable(this.address), CustomerBankModel.hashCodeNullable(this.aliases), CustomerBankModel.hashCodeNullable(this.website), CustomerBankModel.hashCodeNullable(this.dateOfBirth), CustomerBankModel.hashCodeNullable(this.phoneNumber), CustomerBankModel.hashCodeNullable(this.emailAddress), CustomerBankModel.hashCodeNullable(this.labels), this.complianceDecisions, CustomerBankModel.hashCodeNullable(this.identificationNumbers), this.activityLimits);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    complianceDecisions: ").append(this.toIndentedString(this.complianceDecisions)).append("\n");
        sb.append("    identificationNumbers: ").append(this.toIndentedString(this.identificationNumbers)).append("\n");
        sb.append("    activityLimits: ").append(this.toIndentedString(this.activityLimits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

