/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "customer_guid", "account_guid", "created_at", "updated_at", "type", "asset", "receive_amount", "deliver_amount", "fee", "state", "labels"})
@JsonTypeName(value="Invoice")
public class InvoiceBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private String accountGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private JsonNullable<BigInteger> receiveAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private JsonNullable<BigInteger> deliverAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FEE = "fee";
    private JsonNullable<BigInteger> fee = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public InvoiceBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the payment instruction.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public InvoiceBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public InvoiceBankModel accountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account payment will ultimately be received into.")
    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountGuid() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
    }

    public InvoiceBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InvoiceBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public InvoiceBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of invoice; one of lightning.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public InvoiceBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code the customer will receive the funds in.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public InvoiceBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = JsonNullable.of((Object)receiveAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the asset, i.e., the amount the customer will receive after fees. ONLY one of receive_amount or deliver_amount is required.")
    @JsonIgnore
    public BigInteger getReceiveAmount() {
        return (BigInteger)this.receiveAmount.orElse(null);
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getReceiveAmount_JsonNullable() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    public void setReceiveAmount_JsonNullable(JsonNullable<BigInteger> receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = JsonNullable.of((Object)receiveAmount);
    }

    public InvoiceBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = JsonNullable.of((Object)deliverAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the asset, i.e., the amount the customer will receive before fees. ONLY one of receive_amount or deliver_amount is required.")
    @JsonIgnore
    public BigInteger getDeliverAmount() {
        return (BigInteger)this.deliverAmount.orElse(null);
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getDeliverAmount_JsonNullable() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    public void setDeliverAmount_JsonNullable(JsonNullable<BigInteger> deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = JsonNullable.of((Object)deliverAmount);
    }

    public InvoiceBankModel fee(BigInteger fee) {
        this.fee = JsonNullable.of((Object)fee);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee associated with this invoice in base units of the asset.")
    @JsonIgnore
    public BigInteger getFee() {
        return (BigInteger)this.fee.orElse(null);
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getFee_JsonNullable() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    public void setFee_JsonNullable(JsonNullable<BigInteger> fee) {
        this.fee = fee;
    }

    public void setFee(BigInteger fee) {
        this.fee = JsonNullable.of((Object)fee);
    }

    public InvoiceBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the invoice; one of storing, unpaid, cancelling, cancelled, settling, or paid.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public InvoiceBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public InvoiceBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the invoice.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceBankModel invoice = (InvoiceBankModel)o;
        return Objects.equals(this.guid, invoice.guid) && InvoiceBankModel.equalsNullable(this.customerGuid, invoice.customerGuid) && Objects.equals(this.accountGuid, invoice.accountGuid) && Objects.equals(this.createdAt, invoice.createdAt) && Objects.equals(this.updatedAt, invoice.updatedAt) && Objects.equals(this.type, invoice.type) && Objects.equals(this.asset, invoice.asset) && InvoiceBankModel.equalsNullable(this.receiveAmount, invoice.receiveAmount) && InvoiceBankModel.equalsNullable(this.deliverAmount, invoice.deliverAmount) && InvoiceBankModel.equalsNullable(this.fee, invoice.fee) && Objects.equals(this.state, invoice.state) && InvoiceBankModel.equalsNullable(this.labels, invoice.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, InvoiceBankModel.hashCodeNullable(this.customerGuid), this.accountGuid, this.createdAt, this.updatedAt, this.type, this.asset, InvoiceBankModel.hashCodeNullable(this.receiveAmount), InvoiceBankModel.hashCodeNullable(this.deliverAmount), InvoiceBankModel.hashCodeNullable(this.fee), this.state, InvoiceBankModel.hashCodeNullable(this.labels));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

