/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "trade_type", "customer_guid", "quote_guid", "symbol", "side", "state", "failure_code", "receive_amount", "deliver_amount", "fee", "reference_trade_guid", "created_at", "updated_at", "labels"})
@JsonTypeName(value="Trade")
public class TradeBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TRADE_TYPE = "trade_type";
    private String tradeType;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_SIDE = "side";
    private String side;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private JsonNullable<String> failureCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private BigInteger fee;
    public static final String JSON_PROPERTY_REFERENCE_TRADE_GUID = "reference_trade_guid";
    private JsonNullable<String> referenceTradeGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public TradeBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the trade.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public TradeBankModel tradeType(String tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of trade; one of platform, liquidation, or exit.")
    @JsonProperty(value="trade_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTradeType() {
        return this.tradeType;
    }

    @JsonProperty(value="trade_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public TradeBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated customer's identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public TradeBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public TradeBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trade symbol the pricing is related to. Format is asset-counter_asset, e.g., BTC-USD.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public TradeBankModel side(String side) {
        this.side = side;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction of the trade; one of buy or sell.")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSide(String side) {
        this.side = side;
    }

    public TradeBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the trade; one of storing, pending, cancelled, completed, settling, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public TradeBankModel failureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed trades; one of non_sufficient_funds, unsupported, limit_exceeded, expired_quote, or market_volatility.")
    @JsonIgnore
    public String getFailureCode() {
        return (String)this.failureCode.orElse(null);
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFailureCode_JsonNullable() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    public void setFailureCode_JsonNullable(JsonNullable<String> failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
    }

    public TradeBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public TradeBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public TradeBankModel fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee associated with the trade. Denominated in \"counter_asset\" base units")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public TradeBankModel referenceTradeGuid(String referenceTradeGuid) {
        this.referenceTradeGuid = JsonNullable.of((Object)referenceTradeGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The guid of the related trade. Only present on `exit` trades.")
    @JsonIgnore
    public String getReferenceTradeGuid() {
        return (String)this.referenceTradeGuid.orElse(null);
    }

    @JsonProperty(value="reference_trade_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getReferenceTradeGuid_JsonNullable() {
        return this.referenceTradeGuid;
    }

    @JsonProperty(value="reference_trade_guid")
    public void setReferenceTradeGuid_JsonNullable(JsonNullable<String> referenceTradeGuid) {
        this.referenceTradeGuid = referenceTradeGuid;
    }

    public void setReferenceTradeGuid(String referenceTradeGuid) {
        this.referenceTradeGuid = JsonNullable.of((Object)referenceTradeGuid);
    }

    public TradeBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TradeBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TradeBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public TradeBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the trade.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeBankModel trade = (TradeBankModel)o;
        return Objects.equals(this.guid, trade.guid) && Objects.equals(this.tradeType, trade.tradeType) && TradeBankModel.equalsNullable(this.customerGuid, trade.customerGuid) && Objects.equals(this.quoteGuid, trade.quoteGuid) && Objects.equals(this.symbol, trade.symbol) && Objects.equals(this.side, trade.side) && Objects.equals(this.state, trade.state) && TradeBankModel.equalsNullable(this.failureCode, trade.failureCode) && Objects.equals(this.receiveAmount, trade.receiveAmount) && Objects.equals(this.deliverAmount, trade.deliverAmount) && Objects.equals(this.fee, trade.fee) && TradeBankModel.equalsNullable(this.referenceTradeGuid, trade.referenceTradeGuid) && Objects.equals(this.createdAt, trade.createdAt) && Objects.equals(this.updatedAt, trade.updatedAt) && TradeBankModel.equalsNullable(this.labels, trade.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.tradeType, TradeBankModel.hashCodeNullable(this.customerGuid), this.quoteGuid, this.symbol, this.side, this.state, TradeBankModel.hashCodeNullable(this.failureCode), this.receiveAmount, this.deliverAmount, this.fee, TradeBankModel.hashCodeNullable(this.referenceTradeGuid), this.createdAt, this.updatedAt, TradeBankModel.hashCodeNullable(this.labels));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TradeBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    tradeType: ").append(this.toIndentedString(this.tradeType)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    side: ").append(this.toIndentedString(this.side)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    referenceTradeGuid: ").append(this.toIndentedString(this.referenceTradeGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

