/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostTransferParticipantBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for transfer creation.")
@JsonPropertyOrder(value={"quote_guid", "transfer_type", "external_bank_account_guid", "fiat_account_guid", "send_as_deposit_bank_account_guid", "payment_rail", "beneficiary_memo", "source_participants", "destination_participants", "bank_fiat_account_guid", "customer_fiat_account_guid", "source_account_guid", "destination_account_guid", "external_wallet_guid", "customer_guid", "network_fee_account_guid", "expected_behaviours", "labels"})
@JsonTypeName(value="PostTransfer")
public class PostTransferBankModel {
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
    private TransferTypeEnum transferType;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private JsonNullable<String> externalBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FIAT_ACCOUNT_GUID = "fiat_account_guid";
    private JsonNullable<String> fiatAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SEND_AS_DEPOSIT_BANK_ACCOUNT_GUID = "send_as_deposit_bank_account_guid";
    private JsonNullable<String> sendAsDepositBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PAYMENT_RAIL = "payment_rail";
    private JsonNullable<PaymentRailEnum> paymentRail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BENEFICIARY_MEMO = "beneficiary_memo";
    private JsonNullable<String> beneficiaryMemo = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE_PARTICIPANTS = "source_participants";
    private JsonNullable<List<PostTransferParticipantBankModel>> sourceParticipants = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_PARTICIPANTS = "destination_participants";
    private JsonNullable<List<PostTransferParticipantBankModel>> destinationParticipants = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BANK_FIAT_ACCOUNT_GUID = "bank_fiat_account_guid";
    private JsonNullable<String> bankFiatAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_FIAT_ACCOUNT_GUID = "customer_fiat_account_guid";
    private JsonNullable<String> customerFiatAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_GUID = "source_account_guid";
    private JsonNullable<String> sourceAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_GUID = "destination_account_guid";
    private JsonNullable<String> destinationAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_WALLET_GUID = "external_wallet_guid";
    private JsonNullable<String> externalWalletGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_FEE_ACCOUNT_GUID = "network_fee_account_guid";
    private JsonNullable<String> networkFeeAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPECTED_BEHAVIOURS = "expected_behaviours";
    private JsonNullable<List<ExpectedBehavioursEnum>> expectedBehaviours = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostTransferBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public PostTransferBankModel transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of transfer.")
    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public PostTransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's 'plaid' or 'plaid_processor_token' external bank account's identifier. Required when transfer_type is funding or transfer_type is instant_funding.")
    @JsonIgnore
    public String getExternalBankAccountGuid() {
        return (String)this.externalBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalBankAccountGuid_JsonNullable() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    public void setExternalBankAccountGuid_JsonNullable(JsonNullable<String> externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
    }

    public PostTransferBankModel fiatAccountGuid(String fiatAccountGuid) {
        this.fiatAccountGuid = JsonNullable.of((Object)fiatAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the transfer. Required if the customer or bank has multiple fiat accounts. Optional when transfer_type is funding.")
    @JsonIgnore
    public String getFiatAccountGuid() {
        return (String)this.fiatAccountGuid.orElse(null);
    }

    @JsonProperty(value="fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFiatAccountGuid_JsonNullable() {
        return this.fiatAccountGuid;
    }

    @JsonProperty(value="fiat_account_guid")
    public void setFiatAccountGuid_JsonNullable(JsonNullable<String> fiatAccountGuid) {
        this.fiatAccountGuid = fiatAccountGuid;
    }

    public void setFiatAccountGuid(String fiatAccountGuid) {
        this.fiatAccountGuid = JsonNullable.of((Object)fiatAccountGuid);
    }

    public PostTransferBankModel sendAsDepositBankAccountGuid(String sendAsDepositBankAccountGuid) {
        this.sendAsDepositBankAccountGuid = JsonNullable.of((Object)sendAsDepositBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The deposit bank account's identifier. Only valid for withdrawals. The deposit bank account must be owned by the customer or bank initiating the transfer. Optional when transfer_type is funding.")
    @JsonIgnore
    public String getSendAsDepositBankAccountGuid() {
        return (String)this.sendAsDepositBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="send_as_deposit_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSendAsDepositBankAccountGuid_JsonNullable() {
        return this.sendAsDepositBankAccountGuid;
    }

    @JsonProperty(value="send_as_deposit_bank_account_guid")
    public void setSendAsDepositBankAccountGuid_JsonNullable(JsonNullable<String> sendAsDepositBankAccountGuid) {
        this.sendAsDepositBankAccountGuid = sendAsDepositBankAccountGuid;
    }

    public void setSendAsDepositBankAccountGuid(String sendAsDepositBankAccountGuid) {
        this.sendAsDepositBankAccountGuid = JsonNullable.of((Object)sendAsDepositBankAccountGuid);
    }

    public PostTransferBankModel paymentRail(PaymentRailEnum paymentRail) {
        this.paymentRail = JsonNullable.of((Object)((Object)paymentRail));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The desired payment rail to initiate the transfer for. Optional when transfer_type is funding.")
    @JsonIgnore
    public PaymentRailEnum getPaymentRail() {
        return (PaymentRailEnum)((Object)this.paymentRail.orElse(null));
    }

    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PaymentRailEnum> getPaymentRail_JsonNullable() {
        return this.paymentRail;
    }

    @JsonProperty(value="payment_rail")
    public void setPaymentRail_JsonNullable(JsonNullable<PaymentRailEnum> paymentRail) {
        this.paymentRail = paymentRail;
    }

    public void setPaymentRail(PaymentRailEnum paymentRail) {
        this.paymentRail = JsonNullable.of((Object)((Object)paymentRail));
    }

    public PostTransferBankModel beneficiaryMemo(String beneficiaryMemo) {
        this.beneficiaryMemo = JsonNullable.of((Object)beneficiaryMemo);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The memo to send to the counterparty. Optional when transfer_type is funding.")
    @JsonIgnore
    public String getBeneficiaryMemo() {
        return (String)this.beneficiaryMemo.orElse(null);
    }

    @JsonProperty(value="beneficiary_memo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBeneficiaryMemo_JsonNullable() {
        return this.beneficiaryMemo;
    }

    @JsonProperty(value="beneficiary_memo")
    public void setBeneficiaryMemo_JsonNullable(JsonNullable<String> beneficiaryMemo) {
        this.beneficiaryMemo = beneficiaryMemo;
    }

    public void setBeneficiaryMemo(String beneficiaryMemo) {
        this.beneficiaryMemo = JsonNullable.of((Object)beneficiaryMemo);
    }

    public PostTransferBankModel sourceParticipants(List<PostTransferParticipantBankModel> sourceParticipants) {
        this.sourceParticipants = JsonNullable.of(sourceParticipants);
        return this;
    }

    public PostTransferBankModel addSourceParticipantsItem(PostTransferParticipantBankModel sourceParticipantsItem) {
        if (this.sourceParticipants == null || !this.sourceParticipants.isPresent()) {
            this.sourceParticipants = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.sourceParticipants.get()).add(sourceParticipantsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source participants for the transfer. Required when transfer_type is funding, transfer_type is instant_funding, transfer_type is book, transfer_type is crypto, or transfer_type is lightning.")
    @JsonIgnore
    public List<PostTransferParticipantBankModel> getSourceParticipants() {
        return (List)this.sourceParticipants.orElse(null);
    }

    @JsonProperty(value="source_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostTransferParticipantBankModel>> getSourceParticipants_JsonNullable() {
        return this.sourceParticipants;
    }

    @JsonProperty(value="source_participants")
    public void setSourceParticipants_JsonNullable(JsonNullable<List<PostTransferParticipantBankModel>> sourceParticipants) {
        this.sourceParticipants = sourceParticipants;
    }

    public void setSourceParticipants(List<PostTransferParticipantBankModel> sourceParticipants) {
        this.sourceParticipants = JsonNullable.of(sourceParticipants);
    }

    public PostTransferBankModel destinationParticipants(List<PostTransferParticipantBankModel> destinationParticipants) {
        this.destinationParticipants = JsonNullable.of(destinationParticipants);
        return this;
    }

    public PostTransferBankModel addDestinationParticipantsItem(PostTransferParticipantBankModel destinationParticipantsItem) {
        if (this.destinationParticipants == null || !this.destinationParticipants.isPresent()) {
            this.destinationParticipants = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.destinationParticipants.get()).add(destinationParticipantsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination participants for the transfer. Required when transfer_type is funding, transfer_type is instant_funding, transfer_type is book, transfer_type is crypto, or transfer_type is lightning.")
    @JsonIgnore
    public List<PostTransferParticipantBankModel> getDestinationParticipants() {
        return (List)this.destinationParticipants.orElse(null);
    }

    @JsonProperty(value="destination_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostTransferParticipantBankModel>> getDestinationParticipants_JsonNullable() {
        return this.destinationParticipants;
    }

    @JsonProperty(value="destination_participants")
    public void setDestinationParticipants_JsonNullable(JsonNullable<List<PostTransferParticipantBankModel>> destinationParticipants) {
        this.destinationParticipants = destinationParticipants;
    }

    public void setDestinationParticipants(List<PostTransferParticipantBankModel> destinationParticipants) {
        this.destinationParticipants = JsonNullable.of(destinationParticipants);
    }

    public PostTransferBankModel bankFiatAccountGuid(String bankFiatAccountGuid) {
        this.bankFiatAccountGuid = JsonNullable.of((Object)bankFiatAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the transfer. Required if the bank has multiple fiat accounts. Optional when transfer_type is instant_funding or transfer_type is lightning.")
    @JsonIgnore
    public String getBankFiatAccountGuid() {
        return (String)this.bankFiatAccountGuid.orElse(null);
    }

    @JsonProperty(value="bank_fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBankFiatAccountGuid_JsonNullable() {
        return this.bankFiatAccountGuid;
    }

    @JsonProperty(value="bank_fiat_account_guid")
    public void setBankFiatAccountGuid_JsonNullable(JsonNullable<String> bankFiatAccountGuid) {
        this.bankFiatAccountGuid = bankFiatAccountGuid;
    }

    public void setBankFiatAccountGuid(String bankFiatAccountGuid) {
        this.bankFiatAccountGuid = JsonNullable.of((Object)bankFiatAccountGuid);
    }

    public PostTransferBankModel customerFiatAccountGuid(String customerFiatAccountGuid) {
        this.customerFiatAccountGuid = JsonNullable.of((Object)customerFiatAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the transfer. Required if the customer has multiple fiat accounts. Optional when transfer_type is instant_funding or transfer_type is lightning.")
    @JsonIgnore
    public String getCustomerFiatAccountGuid() {
        return (String)this.customerFiatAccountGuid.orElse(null);
    }

    @JsonProperty(value="customer_fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerFiatAccountGuid_JsonNullable() {
        return this.customerFiatAccountGuid;
    }

    @JsonProperty(value="customer_fiat_account_guid")
    public void setCustomerFiatAccountGuid_JsonNullable(JsonNullable<String> customerFiatAccountGuid) {
        this.customerFiatAccountGuid = customerFiatAccountGuid;
    }

    public void setCustomerFiatAccountGuid(String customerFiatAccountGuid) {
        this.customerFiatAccountGuid = JsonNullable.of((Object)customerFiatAccountGuid);
    }

    public PostTransferBankModel sourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = JsonNullable.of((Object)sourceAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source account's identifier. Required when transfer_type is book or transfer_type is inter_account.")
    @JsonIgnore
    public String getSourceAccountGuid() {
        return (String)this.sourceAccountGuid.orElse(null);
    }

    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSourceAccountGuid_JsonNullable() {
        return this.sourceAccountGuid;
    }

    @JsonProperty(value="source_account_guid")
    public void setSourceAccountGuid_JsonNullable(JsonNullable<String> sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
    }

    public void setSourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = JsonNullable.of((Object)sourceAccountGuid);
    }

    public PostTransferBankModel destinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = JsonNullable.of((Object)destinationAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination account's identifier. Required when transfer_type is book or transfer_type is inter_account.")
    @JsonIgnore
    public String getDestinationAccountGuid() {
        return (String)this.destinationAccountGuid.orElse(null);
    }

    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDestinationAccountGuid_JsonNullable() {
        return this.destinationAccountGuid;
    }

    @JsonProperty(value="destination_account_guid")
    public void setDestinationAccountGuid_JsonNullable(JsonNullable<String> destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
    }

    public void setDestinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = JsonNullable.of((Object)destinationAccountGuid);
    }

    public PostTransferBankModel externalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = JsonNullable.of((Object)externalWalletGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's external wallet's identifier. Optional when transfer_type is crypto.")
    @JsonIgnore
    public String getExternalWalletGuid() {
        return (String)this.externalWalletGuid.orElse(null);
    }

    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalWalletGuid_JsonNullable() {
        return this.externalWalletGuid;
    }

    @JsonProperty(value="external_wallet_guid")
    public void setExternalWalletGuid_JsonNullable(JsonNullable<String> externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
    }

    public void setExternalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = JsonNullable.of((Object)externalWalletGuid);
    }

    public PostTransferBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier. Required when transfer_type is lightning.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostTransferBankModel networkFeeAccountGuid(String networkFeeAccountGuid) {
        this.networkFeeAccountGuid = JsonNullable.of((Object)networkFeeAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network fee account's identifier. Required for network fee transfers. Must be the identifier for the customer's or bank's fiat or trading account. For customer's to pay the network fees, include the customer's fiat or trading account guid. For bank's to pay the network fees, include the bank's fiat or trading account guid. Required when transfer_type is lightning.")
    @JsonIgnore
    public String getNetworkFeeAccountGuid() {
        return (String)this.networkFeeAccountGuid.orElse(null);
    }

    @JsonProperty(value="network_fee_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNetworkFeeAccountGuid_JsonNullable() {
        return this.networkFeeAccountGuid;
    }

    @JsonProperty(value="network_fee_account_guid")
    public void setNetworkFeeAccountGuid_JsonNullable(JsonNullable<String> networkFeeAccountGuid) {
        this.networkFeeAccountGuid = networkFeeAccountGuid;
    }

    public void setNetworkFeeAccountGuid(String networkFeeAccountGuid) {
        this.networkFeeAccountGuid = JsonNullable.of((Object)networkFeeAccountGuid);
    }

    public PostTransferBankModel expectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = JsonNullable.of(expectedBehaviours);
        return this;
    }

    public PostTransferBankModel addExpectedBehavioursItem(ExpectedBehavioursEnum expectedBehavioursItem) {
        if (this.expectedBehaviours == null || !this.expectedBehaviours.isPresent()) {
            this.expectedBehaviours = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.expectedBehaviours.get()).add(expectedBehavioursItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected behaviour to simulate. Only applicable for transfers under sandbox banks. The force_review behaviour will force the transfer to be reviewed for funding and instant_funding transfers.")
    @JsonIgnore
    public List<ExpectedBehavioursEnum> getExpectedBehaviours() {
        return (List)this.expectedBehaviours.orElse(null);
    }

    @JsonProperty(value="expected_behaviours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<ExpectedBehavioursEnum>> getExpectedBehaviours_JsonNullable() {
        return this.expectedBehaviours;
    }

    @JsonProperty(value="expected_behaviours")
    public void setExpectedBehaviours_JsonNullable(JsonNullable<List<ExpectedBehavioursEnum>> expectedBehaviours) {
        this.expectedBehaviours = expectedBehaviours;
    }

    public void setExpectedBehaviours(List<ExpectedBehavioursEnum> expectedBehaviours) {
        this.expectedBehaviours = JsonNullable.of(expectedBehaviours);
    }

    public PostTransferBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostTransferBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the transfer.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTransferBankModel postTransfer = (PostTransferBankModel)o;
        return Objects.equals(this.quoteGuid, postTransfer.quoteGuid) && Objects.equals((Object)this.transferType, (Object)postTransfer.transferType) && PostTransferBankModel.equalsNullable(this.externalBankAccountGuid, postTransfer.externalBankAccountGuid) && PostTransferBankModel.equalsNullable(this.fiatAccountGuid, postTransfer.fiatAccountGuid) && PostTransferBankModel.equalsNullable(this.sendAsDepositBankAccountGuid, postTransfer.sendAsDepositBankAccountGuid) && PostTransferBankModel.equalsNullable(this.paymentRail, postTransfer.paymentRail) && PostTransferBankModel.equalsNullable(this.beneficiaryMemo, postTransfer.beneficiaryMemo) && PostTransferBankModel.equalsNullable(this.sourceParticipants, postTransfer.sourceParticipants) && PostTransferBankModel.equalsNullable(this.destinationParticipants, postTransfer.destinationParticipants) && PostTransferBankModel.equalsNullable(this.bankFiatAccountGuid, postTransfer.bankFiatAccountGuid) && PostTransferBankModel.equalsNullable(this.customerFiatAccountGuid, postTransfer.customerFiatAccountGuid) && PostTransferBankModel.equalsNullable(this.sourceAccountGuid, postTransfer.sourceAccountGuid) && PostTransferBankModel.equalsNullable(this.destinationAccountGuid, postTransfer.destinationAccountGuid) && PostTransferBankModel.equalsNullable(this.externalWalletGuid, postTransfer.externalWalletGuid) && PostTransferBankModel.equalsNullable(this.customerGuid, postTransfer.customerGuid) && PostTransferBankModel.equalsNullable(this.networkFeeAccountGuid, postTransfer.networkFeeAccountGuid) && PostTransferBankModel.equalsNullable(this.expectedBehaviours, postTransfer.expectedBehaviours) && PostTransferBankModel.equalsNullable(this.labels, postTransfer.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quoteGuid, this.transferType, PostTransferBankModel.hashCodeNullable(this.externalBankAccountGuid), PostTransferBankModel.hashCodeNullable(this.fiatAccountGuid), PostTransferBankModel.hashCodeNullable(this.sendAsDepositBankAccountGuid), PostTransferBankModel.hashCodeNullable(this.paymentRail), PostTransferBankModel.hashCodeNullable(this.beneficiaryMemo), PostTransferBankModel.hashCodeNullable(this.sourceParticipants), PostTransferBankModel.hashCodeNullable(this.destinationParticipants), PostTransferBankModel.hashCodeNullable(this.bankFiatAccountGuid), PostTransferBankModel.hashCodeNullable(this.customerFiatAccountGuid), PostTransferBankModel.hashCodeNullable(this.sourceAccountGuid), PostTransferBankModel.hashCodeNullable(this.destinationAccountGuid), PostTransferBankModel.hashCodeNullable(this.externalWalletGuid), PostTransferBankModel.hashCodeNullable(this.customerGuid), PostTransferBankModel.hashCodeNullable(this.networkFeeAccountGuid), PostTransferBankModel.hashCodeNullable(this.expectedBehaviours), PostTransferBankModel.hashCodeNullable(this.labels)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTransferBankModel {\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    fiatAccountGuid: ").append(this.toIndentedString(this.fiatAccountGuid)).append("\n");
        sb.append("    sendAsDepositBankAccountGuid: ").append(this.toIndentedString(this.sendAsDepositBankAccountGuid)).append("\n");
        sb.append("    paymentRail: ").append(this.toIndentedString(this.paymentRail)).append("\n");
        sb.append("    beneficiaryMemo: ").append(this.toIndentedString(this.beneficiaryMemo)).append("\n");
        sb.append("    sourceParticipants: ").append(this.toIndentedString(this.sourceParticipants)).append("\n");
        sb.append("    destinationParticipants: ").append(this.toIndentedString(this.destinationParticipants)).append("\n");
        sb.append("    bankFiatAccountGuid: ").append(this.toIndentedString(this.bankFiatAccountGuid)).append("\n");
        sb.append("    customerFiatAccountGuid: ").append(this.toIndentedString(this.customerFiatAccountGuid)).append("\n");
        sb.append("    sourceAccountGuid: ").append(this.toIndentedString(this.sourceAccountGuid)).append("\n");
        sb.append("    destinationAccountGuid: ").append(this.toIndentedString(this.destinationAccountGuid)).append("\n");
        sb.append("    externalWalletGuid: ").append(this.toIndentedString(this.externalWalletGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    networkFeeAccountGuid: ").append(this.toIndentedString(this.networkFeeAccountGuid)).append("\n");
        sb.append("    expectedBehaviours: ").append(this.toIndentedString(this.expectedBehaviours)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedBehavioursEnum {
        FORCE_REVIEW("force_review");

        private String value;

        private ExpectedBehavioursEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedBehavioursEnum fromValue(String value) {
            for (ExpectedBehavioursEnum b : ExpectedBehavioursEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentRailEnum {
        ACH("ach"),
        EFT("eft"),
        WIRE("wire"),
        RTP("rtp");

        private String value;

        private PaymentRailEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentRailEnum fromValue(String value) {
            for (PaymentRailEnum b : PaymentRailEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TransferTypeEnum {
        FUNDING("funding"),
        CRYPTO("crypto"),
        INSTANT_FUNDING("instant_funding"),
        INTER_ACCOUNT("inter_account"),
        LIGHTNING("lightning"),
        BOOK("book");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransferTypeEnum fromValue(String value) {
            for (TransferTypeEnum b : TransferTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

