/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The address of the counterparty.")
@JsonPropertyOrder(value={"street", "street2", "city", "subdivision", "postal_code", "country_code"})
@JsonTypeName(value="PostCounterparty_address")
public class PostCounterpartyAddressBankModel {
    public static final String JSON_PROPERTY_STREET = "street";
    private String street;
    public static final String JSON_PROPERTY_STREET2 = "street2";
    private JsonNullable<String> street2 = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_SUBDIVISION = "subdivision";
    private JsonNullable<String> subdivision = JsonNullable.undefined();
    public static final String JSON_PROPERTY_POSTAL_CODE = "postal_code";
    private JsonNullable<String> postalCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTRY_CODE = "country_code";
    private String countryCode;

    public PostCounterpartyAddressBankModel street(String street) {
        this.street = street;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The first line of the address.")
    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStreet(String street) {
        this.street = street;
    }

    public PostCounterpartyAddressBankModel street2(String street2) {
        this.street2 = JsonNullable.of((Object)street2);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional second line of the address.")
    @JsonIgnore
    public String getStreet2() {
        return (String)this.street2.orElse(null);
    }

    @JsonProperty(value="street2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getStreet2_JsonNullable() {
        return this.street2;
    }

    @JsonProperty(value="street2")
    public void setStreet2_JsonNullable(JsonNullable<String> street2) {
        this.street2 = street2;
    }

    public void setStreet2(String street2) {
        this.street2 = JsonNullable.of((Object)street2);
    }

    public PostCounterpartyAddressBankModel city(String city) {
        this.city = city;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The city of the address.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCity(String city) {
        this.city = city;
    }

    public PostCounterpartyAddressBankModel subdivision(String subdivision) {
        this.subdivision = JsonNullable.of((Object)subdivision);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166-2 subdivision code of the address. Applicable only for countries that use subnational states, provinces, lands, oblasts or regions.")
    @JsonIgnore
    public String getSubdivision() {
        return (String)this.subdivision.orElse(null);
    }

    @JsonProperty(value="subdivision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSubdivision_JsonNullable() {
        return this.subdivision;
    }

    @JsonProperty(value="subdivision")
    public void setSubdivision_JsonNullable(JsonNullable<String> subdivision) {
        this.subdivision = subdivision;
    }

    public void setSubdivision(String subdivision) {
        this.subdivision = JsonNullable.of((Object)subdivision);
    }

    public PostCounterpartyAddressBankModel postalCode(String postalCode) {
        this.postalCode = JsonNullable.of((Object)postalCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal, zip or post code of the address. Applicable only for countries that use postal, zip or post codes.")
    @JsonIgnore
    public String getPostalCode() {
        return (String)this.postalCode.orElse(null);
    }

    @JsonProperty(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPostalCode_JsonNullable() {
        return this.postalCode;
    }

    @JsonProperty(value="postal_code")
    public void setPostalCode_JsonNullable(JsonNullable<String> postalCode) {
        this.postalCode = postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = JsonNullable.of((Object)postalCode);
    }

    public PostCounterpartyAddressBankModel countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The ISO 3166 country 2-Alpha country code of the address.")
    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostCounterpartyAddressBankModel postCounterpartyAddress = (PostCounterpartyAddressBankModel)o;
        return Objects.equals(this.street, postCounterpartyAddress.street) && PostCounterpartyAddressBankModel.equalsNullable(this.street2, postCounterpartyAddress.street2) && Objects.equals(this.city, postCounterpartyAddress.city) && PostCounterpartyAddressBankModel.equalsNullable(this.subdivision, postCounterpartyAddress.subdivision) && PostCounterpartyAddressBankModel.equalsNullable(this.postalCode, postCounterpartyAddress.postalCode) && Objects.equals(this.countryCode, postCounterpartyAddress.countryCode);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.street, PostCounterpartyAddressBankModel.hashCodeNullable(this.street2), this.city, PostCounterpartyAddressBankModel.hashCodeNullable(this.subdivision), PostCounterpartyAddressBankModel.hashCodeNullable(this.postalCode), this.countryCode);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostCounterpartyAddressBankModel {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    subdivision: ").append(this.toIndentedString(this.subdivision)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

