/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "type", "content_type", "filename", "completed_at", "failed_at", "state", "failure_code", "upload_url", "upload_expires_at", "download_url", "download_expires_at"})
@JsonTypeName(value="PlatformFile")
public class PlatformFileBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "content_type";
    private String contentType;
    public static final String JSON_PROPERTY_FILENAME = "filename";
    private String filename;
    public static final String JSON_PROPERTY_COMPLETED_AT = "completed_at";
    private OffsetDateTime completedAt;
    public static final String JSON_PROPERTY_FAILED_AT = "failed_at";
    private OffsetDateTime failedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private JsonNullable<String> failureCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UPLOAD_URL = "upload_url";
    private JsonNullable<URI> uploadUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UPLOAD_EXPIRES_AT = "upload_expires_at";
    private JsonNullable<OffsetDateTime> uploadExpiresAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DOWNLOAD_URL = "download_url";
    private JsonNullable<URI> downloadUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DOWNLOAD_EXPIRES_AT = "download_expires_at";
    private JsonNullable<OffsetDateTime> downloadExpiresAt = JsonNullable.undefined();

    public PlatformFileBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the file.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public PlatformFileBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file type; one of drivers_license_front, drivers_license_back, passport, passport_card, visa, identification_card, residence_card, selfie, selfie_video, selfie_left, selfie_right, utility_bill, proof_of_address, bank_statement, property_tax, tax_document, ein_letter, incorporation_certificate, persona_inquiry_report, or persona_inquiry_export.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public PlatformFileBankModel contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The media type; one of image/jpeg, image/png, application/pdf, application/json, or video/mp4.")
    @JsonProperty(value="content_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public PlatformFileBankModel filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the file.")
    @JsonProperty(value="filename")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="filename")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public PlatformFileBankModel completedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO8601 datetime the file was completed at.")
    @JsonProperty(value="completed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    @JsonProperty(value="completed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public PlatformFileBankModel failedAt(OffsetDateTime failedAt) {
        this.failedAt = failedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO8601 datetime the file failed at.")
    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getFailedAt() {
        return this.failedAt;
    }

    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedAt(OffsetDateTime failedAt) {
        this.failedAt = failedAt;
    }

    public PlatformFileBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the file. One of storing, completed, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public PlatformFileBankModel failureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed files.")
    @JsonIgnore
    public String getFailureCode() {
        return (String)this.failureCode.orElse(null);
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFailureCode_JsonNullable() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    public void setFailureCode_JsonNullable(JsonNullable<String> failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
    }

    public PlatformFileBankModel uploadUrl(URI uploadUrl) {
        this.uploadUrl = JsonNullable.of((Object)uploadUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL to upload the file to.")
    @JsonIgnore
    public URI getUploadUrl() {
        return (URI)this.uploadUrl.orElse(null);
    }

    @JsonProperty(value="upload_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getUploadUrl_JsonNullable() {
        return this.uploadUrl;
    }

    @JsonProperty(value="upload_url")
    public void setUploadUrl_JsonNullable(JsonNullable<URI> uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public void setUploadUrl(URI uploadUrl) {
        this.uploadUrl = JsonNullable.of((Object)uploadUrl);
    }

    public PlatformFileBankModel uploadExpiresAt(OffsetDateTime uploadExpiresAt) {
        this.uploadExpiresAt = JsonNullable.of((Object)uploadExpiresAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO8601 datetime the upload URL expires at.")
    @JsonIgnore
    public OffsetDateTime getUploadExpiresAt() {
        return (OffsetDateTime)this.uploadExpiresAt.orElse(null);
    }

    @JsonProperty(value="upload_expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getUploadExpiresAt_JsonNullable() {
        return this.uploadExpiresAt;
    }

    @JsonProperty(value="upload_expires_at")
    public void setUploadExpiresAt_JsonNullable(JsonNullable<OffsetDateTime> uploadExpiresAt) {
        this.uploadExpiresAt = uploadExpiresAt;
    }

    public void setUploadExpiresAt(OffsetDateTime uploadExpiresAt) {
        this.uploadExpiresAt = JsonNullable.of((Object)uploadExpiresAt);
    }

    public PlatformFileBankModel downloadUrl(URI downloadUrl) {
        this.downloadUrl = JsonNullable.of((Object)downloadUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL to download the file from.")
    @JsonIgnore
    public URI getDownloadUrl() {
        return (URI)this.downloadUrl.orElse(null);
    }

    @JsonProperty(value="download_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getDownloadUrl_JsonNullable() {
        return this.downloadUrl;
    }

    @JsonProperty(value="download_url")
    public void setDownloadUrl_JsonNullable(JsonNullable<URI> downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setDownloadUrl(URI downloadUrl) {
        this.downloadUrl = JsonNullable.of((Object)downloadUrl);
    }

    public PlatformFileBankModel downloadExpiresAt(OffsetDateTime downloadExpiresAt) {
        this.downloadExpiresAt = JsonNullable.of((Object)downloadExpiresAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO8601 datetime the download URL expires at.")
    @JsonIgnore
    public OffsetDateTime getDownloadExpiresAt() {
        return (OffsetDateTime)this.downloadExpiresAt.orElse(null);
    }

    @JsonProperty(value="download_expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getDownloadExpiresAt_JsonNullable() {
        return this.downloadExpiresAt;
    }

    @JsonProperty(value="download_expires_at")
    public void setDownloadExpiresAt_JsonNullable(JsonNullable<OffsetDateTime> downloadExpiresAt) {
        this.downloadExpiresAt = downloadExpiresAt;
    }

    public void setDownloadExpiresAt(OffsetDateTime downloadExpiresAt) {
        this.downloadExpiresAt = JsonNullable.of((Object)downloadExpiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFileBankModel platformFile = (PlatformFileBankModel)o;
        return Objects.equals(this.guid, platformFile.guid) && Objects.equals(this.type, platformFile.type) && Objects.equals(this.contentType, platformFile.contentType) && Objects.equals(this.filename, platformFile.filename) && Objects.equals(this.completedAt, platformFile.completedAt) && Objects.equals(this.failedAt, platformFile.failedAt) && Objects.equals((Object)this.state, (Object)platformFile.state) && PlatformFileBankModel.equalsNullable(this.failureCode, platformFile.failureCode) && PlatformFileBankModel.equalsNullable(this.uploadUrl, platformFile.uploadUrl) && PlatformFileBankModel.equalsNullable(this.uploadExpiresAt, platformFile.uploadExpiresAt) && PlatformFileBankModel.equalsNullable(this.downloadUrl, platformFile.downloadUrl) && PlatformFileBankModel.equalsNullable(this.downloadExpiresAt, platformFile.downloadExpiresAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.type, this.contentType, this.filename, this.completedAt, this.failedAt, this.state, PlatformFileBankModel.hashCodeNullable(this.failureCode), PlatformFileBankModel.hashCodeNullable(this.uploadUrl), PlatformFileBankModel.hashCodeNullable(this.uploadExpiresAt), PlatformFileBankModel.hashCodeNullable(this.downloadUrl), PlatformFileBankModel.hashCodeNullable(this.downloadExpiresAt)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlatformFileBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    failedAt: ").append(this.toIndentedString(this.failedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    uploadUrl: ").append(this.toIndentedString(this.uploadUrl)).append("\n");
        sb.append("    uploadExpiresAt: ").append(this.toIndentedString(this.uploadExpiresAt)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    downloadExpiresAt: ").append(this.toIndentedString(this.downloadExpiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        COMPLETED("completed"),
        FAILED("failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

