/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostFeeBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostQuoteEntryBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for quote creation.")
@JsonPropertyOrder(value={"product_type", "bank_guid", "customer_guid", "receive_amount", "deliver_amount", "asset", "network_address", "fees", "side", "symbol", "destination_accounts", "reference_trade_guid", "source_account_guid", "destination_account_guid"})
@JsonTypeName(value="PostQuote")
public class PostQuoteBankModel {
    public static final String JSON_PROPERTY_PRODUCT_TYPE = "product_type";
    private JsonNullable<ProductTypeEnum> productType = JsonNullable.of((Object)((Object)ProductTypeEnum.TRADING));
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private JsonNullable<String> bankGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private JsonNullable<BigInteger> receiveAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private JsonNullable<BigInteger> deliverAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ASSET = "asset";
    private JsonNullable<String> asset = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_ADDRESS = "network_address";
    private JsonNullable<String> networkAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FEES = "fees";
    private JsonNullable<List<PostFeeBankModel>> fees = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SIDE = "side";
    private JsonNullable<SideEnum> side = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private JsonNullable<String> symbol = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNTS = "destination_accounts";
    private JsonNullable<List<PostQuoteEntryBankModel>> destinationAccounts = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REFERENCE_TRADE_GUID = "reference_trade_guid";
    private JsonNullable<String> referenceTradeGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_GUID = "source_account_guid";
    private JsonNullable<String> sourceAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_GUID = "destination_account_guid";
    private JsonNullable<String> destinationAccountGuid = JsonNullable.undefined();

    public PostQuoteBankModel productType(ProductTypeEnum productType) {
        this.productType = JsonNullable.of((Object)((Object)productType));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of product the quote is for.")
    @JsonIgnore
    public ProductTypeEnum getProductType() {
        return (ProductTypeEnum)((Object)this.productType.orElse(null));
    }

    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ProductTypeEnum> getProductType_JsonNullable() {
        return this.productType;
    }

    @JsonProperty(value="product_type")
    public void setProductType_JsonNullable(JsonNullable<ProductTypeEnum> productType) {
        this.productType = productType;
    }

    public void setProductType(ProductTypeEnum productType) {
        this.productType = JsonNullable.of((Object)((Object)productType));
    }

    public PostQuoteBankModel bankGuid(String bankGuid) {
        this.bankGuid = JsonNullable.of((Object)bankGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the bank.")
    @JsonIgnore
    public String getBankGuid() {
        return (String)this.bankGuid.orElse(null);
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBankGuid_JsonNullable() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    public void setBankGuid_JsonNullable(JsonNullable<String> bankGuid) {
        this.bankGuid = bankGuid;
    }

    public void setBankGuid(String bankGuid) {
        this.bankGuid = JsonNullable.of((Object)bankGuid);
    }

    public PostQuoteBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostQuoteBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = JsonNullable.of((Object)receiveAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell for trade quotes.")
    @JsonIgnore
    public BigInteger getReceiveAmount() {
        return (BigInteger)this.receiveAmount.orElse(null);
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getReceiveAmount_JsonNullable() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    public void setReceiveAmount_JsonNullable(JsonNullable<BigInteger> receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = JsonNullable.of((Object)receiveAmount);
    }

    public PostQuoteBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = JsonNullable.of((Object)deliverAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell for trade quotes.")
    @JsonIgnore
    public BigInteger getDeliverAmount() {
        return (BigInteger)this.deliverAmount.orElse(null);
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getDeliverAmount_JsonNullable() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    public void setDeliverAmount_JsonNullable(JsonNullable<BigInteger> deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = JsonNullable.of((Object)deliverAmount);
    }

    public PostQuoteBankModel asset(String asset) {
        this.asset = JsonNullable.of((Object)asset);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code the quote was requested for. Required when product_type is lightning_transfer, product_type is book_transfer, product_type is funding, product_type is crypto_transfer, or product_type is inter_account.")
    @JsonIgnore
    public String getAsset() {
        return (String)this.asset.orElse(null);
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAsset_JsonNullable() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    public void setAsset_JsonNullable(JsonNullable<String> asset) {
        this.asset = asset;
    }

    public void setAsset(String asset) {
        this.asset = JsonNullable.of((Object)asset);
    }

    public PostQuoteBankModel networkAddress(String networkAddress) {
        this.networkAddress = JsonNullable.of((Object)networkAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network address to pay the invoice to. Required when product_type is lightning_transfer.")
    @JsonIgnore
    public String getNetworkAddress() {
        return (String)this.networkAddress.orElse(null);
    }

    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNetworkAddress_JsonNullable() {
        return this.networkAddress;
    }

    @JsonProperty(value="network_address")
    public void setNetworkAddress_JsonNullable(JsonNullable<String> networkAddress) {
        this.networkAddress = networkAddress;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = JsonNullable.of((Object)networkAddress);
    }

    public PostQuoteBankModel fees(List<PostFeeBankModel> fees) {
        this.fees = JsonNullable.of(fees);
        return this;
    }

    public PostQuoteBankModel addFeesItem(PostFeeBankModel feesItem) {
        if (this.fees == null || !this.fees.isPresent()) {
            this.fees = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.fees.get()).add(feesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The custom fees associated with the quote Optional when product_type is lightning_transfer, product_type is funding, product_type is trading, product_type is crypto_transfer, or product_type is trading_exit.")
    @JsonIgnore
    public List<PostFeeBankModel> getFees() {
        return (List)this.fees.orElse(null);
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostFeeBankModel>> getFees_JsonNullable() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    public void setFees_JsonNullable(JsonNullable<List<PostFeeBankModel>> fees) {
        this.fees = fees;
    }

    public void setFees(List<PostFeeBankModel> fees) {
        this.fees = JsonNullable.of(fees);
    }

    public PostQuoteBankModel side(SideEnum side) {
        this.side = JsonNullable.of((Object)((Object)side));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction for trade quotes: either 'buy' or 'sell'. The direction for funding quotes: either 'deposit' or 'withdrawal'. The direction for crypto transfer quotes: 'withdrawal'. Book transfers do not require a side. They are all 'deposit's.  Required when product_type is funding, product_type is trading, or product_type is crypto_transfer.")
    @JsonIgnore
    public SideEnum getSide() {
        return (SideEnum)((Object)this.side.orElse(null));
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SideEnum> getSide_JsonNullable() {
        return this.side;
    }

    @JsonProperty(value="side")
    public void setSide_JsonNullable(JsonNullable<SideEnum> side) {
        this.side = side;
    }

    public void setSide(SideEnum side) {
        this.side = JsonNullable.of((Object)((Object)side));
    }

    public PostQuoteBankModel symbol(String symbol) {
        this.symbol = JsonNullable.of((Object)symbol);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol the quote is being requested for. Format is \"asset-counter_asset\" in uppercase. See the Symbols API for a complete list of cryptocurrencies supported.  Required when product_type is trading.")
    @JsonIgnore
    public String getSymbol() {
        return (String)this.symbol.orElse(null);
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSymbol_JsonNullable() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    public void setSymbol_JsonNullable(JsonNullable<String> symbol) {
        this.symbol = symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = JsonNullable.of((Object)symbol);
    }

    public PostQuoteBankModel destinationAccounts(List<PostQuoteEntryBankModel> destinationAccounts) {
        this.destinationAccounts = JsonNullable.of(destinationAccounts);
        return this;
    }

    public PostQuoteBankModel addDestinationAccountsItem(PostQuoteEntryBankModel destinationAccountsItem) {
        if (this.destinationAccounts == null || !this.destinationAccounts.isPresent()) {
            this.destinationAccounts = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.destinationAccounts.get()).add(destinationAccountsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Destination accounts for batch transactions Optional when product_type is crypto_transfer.")
    @JsonIgnore
    public List<PostQuoteEntryBankModel> getDestinationAccounts() {
        return (List)this.destinationAccounts.orElse(null);
    }

    @JsonProperty(value="destination_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostQuoteEntryBankModel>> getDestinationAccounts_JsonNullable() {
        return this.destinationAccounts;
    }

    @JsonProperty(value="destination_accounts")
    public void setDestinationAccounts_JsonNullable(JsonNullable<List<PostQuoteEntryBankModel>> destinationAccounts) {
        this.destinationAccounts = destinationAccounts;
    }

    public void setDestinationAccounts(List<PostQuoteEntryBankModel> destinationAccounts) {
        this.destinationAccounts = JsonNullable.of(destinationAccounts);
    }

    public PostQuoteBankModel referenceTradeGuid(String referenceTradeGuid) {
        this.referenceTradeGuid = JsonNullable.of((Object)referenceTradeGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The guid of the related trade. Only present on `exit` trades. Required when product_type is trading_exit.")
    @JsonIgnore
    public String getReferenceTradeGuid() {
        return (String)this.referenceTradeGuid.orElse(null);
    }

    @JsonProperty(value="reference_trade_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getReferenceTradeGuid_JsonNullable() {
        return this.referenceTradeGuid;
    }

    @JsonProperty(value="reference_trade_guid")
    public void setReferenceTradeGuid_JsonNullable(JsonNullable<String> referenceTradeGuid) {
        this.referenceTradeGuid = referenceTradeGuid;
    }

    public void setReferenceTradeGuid(String referenceTradeGuid) {
        this.referenceTradeGuid = JsonNullable.of((Object)referenceTradeGuid);
    }

    public PostQuoteBankModel sourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = JsonNullable.of((Object)sourceAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source account's identifier. Required when product_type is inter_account.")
    @JsonIgnore
    public String getSourceAccountGuid() {
        return (String)this.sourceAccountGuid.orElse(null);
    }

    @JsonProperty(value="source_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSourceAccountGuid_JsonNullable() {
        return this.sourceAccountGuid;
    }

    @JsonProperty(value="source_account_guid")
    public void setSourceAccountGuid_JsonNullable(JsonNullable<String> sourceAccountGuid) {
        this.sourceAccountGuid = sourceAccountGuid;
    }

    public void setSourceAccountGuid(String sourceAccountGuid) {
        this.sourceAccountGuid = JsonNullable.of((Object)sourceAccountGuid);
    }

    public PostQuoteBankModel destinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = JsonNullable.of((Object)destinationAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination account's identifier. Required when product_type is inter_account.")
    @JsonIgnore
    public String getDestinationAccountGuid() {
        return (String)this.destinationAccountGuid.orElse(null);
    }

    @JsonProperty(value="destination_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDestinationAccountGuid_JsonNullable() {
        return this.destinationAccountGuid;
    }

    @JsonProperty(value="destination_account_guid")
    public void setDestinationAccountGuid_JsonNullable(JsonNullable<String> destinationAccountGuid) {
        this.destinationAccountGuid = destinationAccountGuid;
    }

    public void setDestinationAccountGuid(String destinationAccountGuid) {
        this.destinationAccountGuid = JsonNullable.of((Object)destinationAccountGuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostQuoteBankModel postQuote = (PostQuoteBankModel)o;
        return PostQuoteBankModel.equalsNullable(this.productType, postQuote.productType) && PostQuoteBankModel.equalsNullable(this.bankGuid, postQuote.bankGuid) && PostQuoteBankModel.equalsNullable(this.customerGuid, postQuote.customerGuid) && PostQuoteBankModel.equalsNullable(this.receiveAmount, postQuote.receiveAmount) && PostQuoteBankModel.equalsNullable(this.deliverAmount, postQuote.deliverAmount) && PostQuoteBankModel.equalsNullable(this.asset, postQuote.asset) && PostQuoteBankModel.equalsNullable(this.networkAddress, postQuote.networkAddress) && PostQuoteBankModel.equalsNullable(this.fees, postQuote.fees) && PostQuoteBankModel.equalsNullable(this.side, postQuote.side) && PostQuoteBankModel.equalsNullable(this.symbol, postQuote.symbol) && PostQuoteBankModel.equalsNullable(this.destinationAccounts, postQuote.destinationAccounts) && PostQuoteBankModel.equalsNullable(this.referenceTradeGuid, postQuote.referenceTradeGuid) && PostQuoteBankModel.equalsNullable(this.sourceAccountGuid, postQuote.sourceAccountGuid) && PostQuoteBankModel.equalsNullable(this.destinationAccountGuid, postQuote.destinationAccountGuid);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(PostQuoteBankModel.hashCodeNullable(this.productType), PostQuoteBankModel.hashCodeNullable(this.bankGuid), PostQuoteBankModel.hashCodeNullable(this.customerGuid), PostQuoteBankModel.hashCodeNullable(this.receiveAmount), PostQuoteBankModel.hashCodeNullable(this.deliverAmount), PostQuoteBankModel.hashCodeNullable(this.asset), PostQuoteBankModel.hashCodeNullable(this.networkAddress), PostQuoteBankModel.hashCodeNullable(this.fees), PostQuoteBankModel.hashCodeNullable(this.side), PostQuoteBankModel.hashCodeNullable(this.symbol), PostQuoteBankModel.hashCodeNullable(this.destinationAccounts), PostQuoteBankModel.hashCodeNullable(this.referenceTradeGuid), PostQuoteBankModel.hashCodeNullable(this.sourceAccountGuid), PostQuoteBankModel.hashCodeNullable(this.destinationAccountGuid));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostQuoteBankModel {\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    networkAddress: ").append(this.toIndentedString(this.networkAddress)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    side: ").append(this.toIndentedString(this.side)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    destinationAccounts: ").append(this.toIndentedString(this.destinationAccounts)).append("\n");
        sb.append("    referenceTradeGuid: ").append(this.toIndentedString(this.referenceTradeGuid)).append("\n");
        sb.append("    sourceAccountGuid: ").append(this.toIndentedString(this.sourceAccountGuid)).append("\n");
        sb.append("    destinationAccountGuid: ").append(this.toIndentedString(this.destinationAccountGuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SideEnum {
        DEPOSIT("deposit"),
        WITHDRAWAL("withdrawal"),
        BUY("buy"),
        SELL("sell");

        private String value;

        private SideEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SideEnum fromValue(String value) {
            for (SideEnum b : SideEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ProductTypeEnum {
        TRADING("trading"),
        TRADING_EXIT("trading_exit"),
        FUNDING("funding"),
        CRYPTO_TRANSFER("crypto_transfer"),
        INTER_ACCOUNT("inter_account"),
        LIGHTNING_TRANSFER("lightning_transfer"),
        BOOK_TRANSFER("book_transfer");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String value) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

