/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for deposit bank account creation.")
@JsonPropertyOrder(value={"type", "account_guid", "customer_guid", "parent_deposit_bank_account_guid", "labels"})
@JsonTypeName(value="PostDepositBankAccount")
public class PostDepositBankAccountBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private String accountGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PARENT_DEPOSIT_BANK_ACCOUNT_GUID = "parent_deposit_bank_account_guid";
    private JsonNullable<String> parentDepositBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostDepositBankAccountBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The account type. To generate deposit bank accounts with their own unique account number set this to \"main\". To generate deposit bank accounts with the same account number as the parent deposit bank account set this to \"sub_account\". This setting will only generate a unique identifier for the deposit bank and will not result in a unique account number being generated. \"sub_account\" is only  available for customer-level deposit bank accounts.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostDepositBankAccountBankModel accountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fiat account guid.")
    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountGuid() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
    }

    public PostDepositBankAccountBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostDepositBankAccountBankModel parentDepositBankAccountGuid(String parentDepositBankAccountGuid) {
        this.parentDepositBankAccountGuid = JsonNullable.of((Object)parentDepositBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the bank-level deposit bank account. This is only required for sub-accounts. Required when type is sub_account.")
    @JsonIgnore
    public String getParentDepositBankAccountGuid() {
        return (String)this.parentDepositBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="parent_deposit_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getParentDepositBankAccountGuid_JsonNullable() {
        return this.parentDepositBankAccountGuid;
    }

    @JsonProperty(value="parent_deposit_bank_account_guid")
    public void setParentDepositBankAccountGuid_JsonNullable(JsonNullable<String> parentDepositBankAccountGuid) {
        this.parentDepositBankAccountGuid = parentDepositBankAccountGuid;
    }

    public void setParentDepositBankAccountGuid(String parentDepositBankAccountGuid) {
        this.parentDepositBankAccountGuid = JsonNullable.of((Object)parentDepositBankAccountGuid);
    }

    public PostDepositBankAccountBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostDepositBankAccountBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the bank account.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostDepositBankAccountBankModel postDepositBankAccount = (PostDepositBankAccountBankModel)o;
        return Objects.equals((Object)this.type, (Object)postDepositBankAccount.type) && Objects.equals(this.accountGuid, postDepositBankAccount.accountGuid) && PostDepositBankAccountBankModel.equalsNullable(this.customerGuid, postDepositBankAccount.customerGuid) && PostDepositBankAccountBankModel.equalsNullable(this.parentDepositBankAccountGuid, postDepositBankAccount.parentDepositBankAccountGuid) && PostDepositBankAccountBankModel.equalsNullable(this.labels, postDepositBankAccount.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.accountGuid, PostDepositBankAccountBankModel.hashCodeNullable(this.customerGuid), PostDepositBankAccountBankModel.hashCodeNullable(this.parentDepositBankAccountGuid), PostDepositBankAccountBankModel.hashCodeNullable(this.labels)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostDepositBankAccountBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    parentDepositBankAccountGuid: ").append(this.toIndentedString(this.parentDepositBankAccountGuid)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MAIN("main"),
        SUB_ACCOUNT("sub_account");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

