/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for a new file.")
@JsonPropertyOrder(value={"type", "customer_guid", "filename", "content_type", "data"})
@JsonTypeName(value="PostFile")
public class PostFileBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_FILENAME = "filename";
    private String filename;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "content_type";
    private ContentTypeEnum contentType;
    public static final String JSON_PROPERTY_DATA = "data";
    private JsonNullable<String> data = JsonNullable.undefined();

    public PostFileBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of file.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostFileBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The customer identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostFileBankModel filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the file.")
    @JsonProperty(value="filename")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="filename")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public PostFileBankModel contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The content type of the file.")
    @JsonProperty(value="content_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public PostFileBankModel data(String data) {
        this.data = JsonNullable.of((Object)data);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64 encoded file content")
    @JsonIgnore
    public String getData() {
        return (String)this.data.orElse(null);
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getData_JsonNullable() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData_JsonNullable(JsonNullable<String> data) {
        this.data = data;
    }

    public void setData(String data) {
        this.data = JsonNullable.of((Object)data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFileBankModel postFile = (PostFileBankModel)o;
        return Objects.equals((Object)this.type, (Object)postFile.type) && Objects.equals(this.customerGuid, postFile.customerGuid) && Objects.equals(this.filename, postFile.filename) && Objects.equals((Object)this.contentType, (Object)postFile.contentType) && PostFileBankModel.equalsNullable(this.data, postFile.data);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.customerGuid, this.filename, this.contentType, PostFileBankModel.hashCodeNullable(this.data)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostFileBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContentTypeEnum {
        IMAGE_JPEG("image/jpeg"),
        IMAGE_PNG("image/png"),
        APPLICATION_PDF("application/pdf"),
        APPLICATION_JSON("application/json"),
        VIDEO_MP4("video/mp4");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        DRIVERS_LICENSE_FRONT("drivers_license_front"),
        DRIVERS_LICENSE_BACK("drivers_license_back"),
        PASSPORT("passport"),
        PASSPORT_CARD("passport_card"),
        VISA("visa"),
        IDENTIFICATION_CARD("identification_card"),
        RESIDENCE_CARD("residence_card"),
        SELFIE("selfie"),
        SELFIE_VIDEO("selfie_video"),
        SELFIE_LEFT("selfie_left"),
        SELFIE_RIGHT("selfie_right"),
        UTILITY_BILL("utility_bill"),
        PROOF_OF_ADDRESS("proof_of_address"),
        BANK_STATEMENT("bank_statement"),
        PROPERTY_TAX("property_tax"),
        TAX_DOCUMENT("tax_document"),
        EIN_LETTER("ein_letter"),
        INCORPORATION_CERTIFICATE("incorporation_certificate"),
        PERSONA_INQUIRY_REPORT("persona_inquiry_report"),
        PERSONA_INQUIRY_EXPORT("persona_inquiry_export");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

