/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.ComplianceDecisionBankModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "type", "method", "created_at", "updated_at", "customer_guid", "counterparty_guid", "external_bank_account_guid", "state", "outcome", "failure_codes", "compliance_decisions"})
@JsonTypeName(value="IdentityVerification")
public class IdentityVerificationBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_GUID = "counterparty_guid";
    private JsonNullable<String> counterpartyGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private JsonNullable<String> externalBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private JsonNullable<String> outcome = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private JsonNullable<List<String>> failureCodes = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COMPLIANCE_DECISIONS = "compliance_decisions";
    private List<ComplianceDecisionBankModel> complianceDecisions = null;

    public IdentityVerificationBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the identity verification.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public IdentityVerificationBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification type; one of kyc, bank_account, or counterparty.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public IdentityVerificationBankModel method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification method; one of attested, document_submission, enhanced_due_diligence, id_and_selfie, tax_id_and_selfie, business_registration, attested_id_and_selfie, attested_business_registration, watchlists, attested_ownership, or account_ownership.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    public IdentityVerificationBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public IdentityVerificationBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public IdentityVerificationBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public IdentityVerificationBankModel counterpartyGuid(String counterpartyGuid) {
        this.counterpartyGuid = JsonNullable.of((Object)counterpartyGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's identifier.")
    @JsonIgnore
    public String getCounterpartyGuid() {
        return (String)this.counterpartyGuid.orElse(null);
    }

    @JsonProperty(value="counterparty_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCounterpartyGuid_JsonNullable() {
        return this.counterpartyGuid;
    }

    @JsonProperty(value="counterparty_guid")
    public void setCounterpartyGuid_JsonNullable(JsonNullable<String> counterpartyGuid) {
        this.counterpartyGuid = counterpartyGuid;
    }

    public void setCounterpartyGuid(String counterpartyGuid) {
        this.counterpartyGuid = JsonNullable.of((Object)counterpartyGuid);
    }

    public IdentityVerificationBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external bank account's identifier.")
    @JsonIgnore
    public String getExternalBankAccountGuid() {
        return (String)this.externalBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalBankAccountGuid_JsonNullable() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    public void setExternalBankAccountGuid_JsonNullable(JsonNullable<String> externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
    }

    public IdentityVerificationBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification state; one of storing, waiting, pending, reviewing, expired, or completed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public IdentityVerificationBankModel outcome(String outcome) {
        this.outcome = JsonNullable.of((Object)outcome);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity verification outcome; one of passed or failed.")
    @JsonIgnore
    public String getOutcome() {
        return (String)this.outcome.orElse(null);
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOutcome_JsonNullable() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    public void setOutcome_JsonNullable(JsonNullable<String> outcome) {
        this.outcome = outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = JsonNullable.of((Object)outcome);
    }

    public IdentityVerificationBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = JsonNullable.of(failureCodes);
        return this;
    }

    public IdentityVerificationBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null || !this.failureCodes.isPresent()) {
            this.failureCodes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.failureCodes.get()).add(failureCodesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonIgnore
    public List<String> getFailureCodes() {
        return (List)this.failureCodes.orElse(null);
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getFailureCodes_JsonNullable() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    public void setFailureCodes_JsonNullable(JsonNullable<List<String>> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = JsonNullable.of(failureCodes);
    }

    public IdentityVerificationBankModel complianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
        return this;
    }

    public IdentityVerificationBankModel addComplianceDecisionsItem(ComplianceDecisionBankModel complianceDecisionsItem) {
        if (this.complianceDecisions == null) {
            this.complianceDecisions = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.complianceDecisions.add(complianceDecisionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The compliance decisions associated with the identity verification.")
    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getComplianceDecisions() {
        return this.complianceDecisions;
    }

    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComplianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationBankModel identityVerification = (IdentityVerificationBankModel)o;
        return Objects.equals(this.guid, identityVerification.guid) && Objects.equals(this.type, identityVerification.type) && Objects.equals(this.method, identityVerification.method) && Objects.equals(this.createdAt, identityVerification.createdAt) && Objects.equals(this.updatedAt, identityVerification.updatedAt) && IdentityVerificationBankModel.equalsNullable(this.customerGuid, identityVerification.customerGuid) && IdentityVerificationBankModel.equalsNullable(this.counterpartyGuid, identityVerification.counterpartyGuid) && IdentityVerificationBankModel.equalsNullable(this.externalBankAccountGuid, identityVerification.externalBankAccountGuid) && Objects.equals(this.state, identityVerification.state) && IdentityVerificationBankModel.equalsNullable(this.outcome, identityVerification.outcome) && IdentityVerificationBankModel.equalsNullable(this.failureCodes, identityVerification.failureCodes) && Objects.equals(this.complianceDecisions, identityVerification.complianceDecisions);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.type, this.method, this.createdAt, this.updatedAt, IdentityVerificationBankModel.hashCodeNullable(this.customerGuid), IdentityVerificationBankModel.hashCodeNullable(this.counterpartyGuid), IdentityVerificationBankModel.hashCodeNullable(this.externalBankAccountGuid), this.state, IdentityVerificationBankModel.hashCodeNullable(this.outcome), IdentityVerificationBankModel.hashCodeNullable(this.failureCodes), this.complianceDecisions);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    counterpartyGuid: ").append(this.toIndentedString(this.counterpartyGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("    complianceDecisions: ").append(this.toIndentedString(this.complianceDecisions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

