/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for invoice creation.")
@JsonPropertyOrder(value={"asset", "customer_guid", "receive_amount", "deliver_amount", "account_guid", "labels"})
@JsonTypeName(value="PostInvoice")
public class PostInvoiceBankModel {
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private JsonNullable<BigInteger> receiveAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private JsonNullable<BigInteger> deliverAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private JsonNullable<String> accountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostInvoiceBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The asset code the customer will receive the funds in.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public PostInvoiceBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostInvoiceBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = JsonNullable.of((Object)receiveAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the asset, i.e., the amount the customer will receive after fees. ONLY one of receive_amount or deliver_amount is required.")
    @JsonIgnore
    public BigInteger getReceiveAmount() {
        return (BigInteger)this.receiveAmount.orElse(null);
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getReceiveAmount_JsonNullable() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    public void setReceiveAmount_JsonNullable(JsonNullable<BigInteger> receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = JsonNullable.of((Object)receiveAmount);
    }

    public PostInvoiceBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = JsonNullable.of((Object)deliverAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the asset, i.e., the amount the customer will receive before fees. ONLY one of receive_amount or deliver_amount is required.")
    @JsonIgnore
    public BigInteger getDeliverAmount() {
        return (BigInteger)this.deliverAmount.orElse(null);
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getDeliverAmount_JsonNullable() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    public void setDeliverAmount_JsonNullable(JsonNullable<BigInteger> deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = JsonNullable.of((Object)deliverAmount);
    }

    public PostInvoiceBankModel accountGuid(String accountGuid) {
        this.accountGuid = JsonNullable.of((Object)accountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the account to use for the transfer. Required if the customer has multiple fiat accounts. Currently only valid for invoices paid to a fiat account.")
    @JsonIgnore
    public String getAccountGuid() {
        return (String)this.accountGuid.orElse(null);
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAccountGuid_JsonNullable() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    public void setAccountGuid_JsonNullable(JsonNullable<String> accountGuid) {
        this.accountGuid = accountGuid;
    }

    public void setAccountGuid(String accountGuid) {
        this.accountGuid = JsonNullable.of((Object)accountGuid);
    }

    public PostInvoiceBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostInvoiceBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the invoice.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostInvoiceBankModel postInvoice = (PostInvoiceBankModel)o;
        return Objects.equals(this.asset, postInvoice.asset) && PostInvoiceBankModel.equalsNullable(this.customerGuid, postInvoice.customerGuid) && PostInvoiceBankModel.equalsNullable(this.receiveAmount, postInvoice.receiveAmount) && PostInvoiceBankModel.equalsNullable(this.deliverAmount, postInvoice.deliverAmount) && PostInvoiceBankModel.equalsNullable(this.accountGuid, postInvoice.accountGuid) && PostInvoiceBankModel.equalsNullable(this.labels, postInvoice.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.asset, PostInvoiceBankModel.hashCodeNullable(this.customerGuid), PostInvoiceBankModel.hashCodeNullable(this.receiveAmount), PostInvoiceBankModel.hashCodeNullable(this.deliverAmount), PostInvoiceBankModel.hashCodeNullable(this.accountGuid), PostInvoiceBankModel.hashCodeNullable(this.labels));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostInvoiceBankModel {\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

