/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Request body for quote account creation.")
@JsonPropertyOrder(value={"type", "guid", "receive_amount", "deliver_amount"})
@JsonTypeName(value="PostQuoteEntry")
public class PostQuoteEntryBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;

    public PostQuoteEntryBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of account")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostQuoteEntryBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The guid of the account")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public PostQuoteEntryBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell for trade quotes.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public PostQuoteEntryBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell for trade quotes.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostQuoteEntryBankModel postQuoteEntry = (PostQuoteEntryBankModel)o;
        return Objects.equals((Object)this.type, (Object)postQuoteEntry.type) && Objects.equals(this.guid, postQuoteEntry.guid) && Objects.equals(this.receiveAmount, postQuoteEntry.receiveAmount) && Objects.equals(this.deliverAmount, postQuoteEntry.deliverAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.guid, this.receiveAmount, this.deliverAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostQuoteEntryBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        EXTERNAL_WALLET("external_wallet");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

