/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.IdentityVerificationDocumentFileBankModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "type", "validated", "expiration_date", "files"})
@JsonTypeName(value="IdentityVerificationDocument")
public class IdentityVerificationDocumentBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_VALIDATED = "validated";
    private Boolean validated;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expiration_date";
    private JsonNullable<LocalDate> expirationDate = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FILES = "files";
    private List<IdentityVerificationDocumentFileBankModel> files = null;

    public IdentityVerificationDocumentBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the document.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public IdentityVerificationDocumentBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The document type; one of drivers_license, passport, passport_card, residence_card, visa, social_security_number, tax_identification_number, selfie, proof_of_address, formation_document, or employer_identification_number.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public IdentityVerificationDocumentBankModel validated(Boolean validated) {
        this.validated = validated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the document has been validated.")
    @JsonProperty(value="validated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidated() {
        return this.validated;
    }

    @JsonProperty(value="validated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidated(Boolean validated) {
        this.validated = validated;
    }

    public IdentityVerificationDocumentBankModel expirationDate(LocalDate expirationDate) {
        this.expirationDate = JsonNullable.of((Object)expirationDate);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The document expiration date.")
    @JsonIgnore
    public LocalDate getExpirationDate() {
        return (LocalDate)this.expirationDate.orElse(null);
    }

    @JsonProperty(value="expiration_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getExpirationDate_JsonNullable() {
        return this.expirationDate;
    }

    @JsonProperty(value="expiration_date")
    public void setExpirationDate_JsonNullable(JsonNullable<LocalDate> expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = JsonNullable.of((Object)expirationDate);
    }

    public IdentityVerificationDocumentBankModel files(List<IdentityVerificationDocumentFileBankModel> files) {
        this.files = files;
        return this;
    }

    public IdentityVerificationDocumentBankModel addFilesItem(IdentityVerificationDocumentFileBankModel filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<IdentityVerificationDocumentFileBankModel>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The files associated with the document.")
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentityVerificationDocumentFileBankModel> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiles(List<IdentityVerificationDocumentFileBankModel> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityVerificationDocumentBankModel identityVerificationDocument = (IdentityVerificationDocumentBankModel)o;
        return Objects.equals(this.guid, identityVerificationDocument.guid) && Objects.equals(this.type, identityVerificationDocument.type) && Objects.equals(this.validated, identityVerificationDocument.validated) && IdentityVerificationDocumentBankModel.equalsNullable(this.expirationDate, identityVerificationDocument.expirationDate) && Objects.equals(this.files, identityVerificationDocument.files);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.type, this.validated, IdentityVerificationDocumentBankModel.hashCodeNullable(this.expirationDate), this.files);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityVerificationDocumentBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validated: ").append(this.toIndentedString(this.validated)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

