/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The counterparty's address. Only available for GET operations when 'include_pii' is set.")
@JsonPropertyOrder(value={"street", "street2", "city", "subdivision", "postal_code", "country_code"})
@JsonTypeName(value="Counterparty_address")
public class CounterpartyAddressBankModel {
    public static final String JSON_PROPERTY_STREET = "street";
    private JsonNullable<String> street = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STREET2 = "street2";
    private JsonNullable<String> street2 = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CITY = "city";
    private JsonNullable<String> city = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SUBDIVISION = "subdivision";
    private JsonNullable<String> subdivision = JsonNullable.undefined();
    public static final String JSON_PROPERTY_POSTAL_CODE = "postal_code";
    private JsonNullable<String> postalCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTRY_CODE = "country_code";
    private JsonNullable<String> countryCode = JsonNullable.undefined();

    public CounterpartyAddressBankModel street(String street) {
        this.street = JsonNullable.of((Object)street);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The first line of the address.")
    @JsonIgnore
    public String getStreet() {
        return (String)this.street.orElse(null);
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getStreet_JsonNullable() {
        return this.street;
    }

    @JsonProperty(value="street")
    public void setStreet_JsonNullable(JsonNullable<String> street) {
        this.street = street;
    }

    public void setStreet(String street) {
        this.street = JsonNullable.of((Object)street);
    }

    public CounterpartyAddressBankModel street2(String street2) {
        this.street2 = JsonNullable.of((Object)street2);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional second line of the address.")
    @JsonIgnore
    public String getStreet2() {
        return (String)this.street2.orElse(null);
    }

    @JsonProperty(value="street2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getStreet2_JsonNullable() {
        return this.street2;
    }

    @JsonProperty(value="street2")
    public void setStreet2_JsonNullable(JsonNullable<String> street2) {
        this.street2 = street2;
    }

    public void setStreet2(String street2) {
        this.street2 = JsonNullable.of((Object)street2);
    }

    public CounterpartyAddressBankModel city(String city) {
        this.city = JsonNullable.of((Object)city);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The city of the address.")
    @JsonIgnore
    public String getCity() {
        return (String)this.city.orElse(null);
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCity_JsonNullable() {
        return this.city;
    }

    @JsonProperty(value="city")
    public void setCity_JsonNullable(JsonNullable<String> city) {
        this.city = city;
    }

    public void setCity(String city) {
        this.city = JsonNullable.of((Object)city);
    }

    public CounterpartyAddressBankModel subdivision(String subdivision) {
        this.subdivision = JsonNullable.of((Object)subdivision);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166-2 subdivision code of the address; not used by all countries.")
    @JsonIgnore
    public String getSubdivision() {
        return (String)this.subdivision.orElse(null);
    }

    @JsonProperty(value="subdivision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSubdivision_JsonNullable() {
        return this.subdivision;
    }

    @JsonProperty(value="subdivision")
    public void setSubdivision_JsonNullable(JsonNullable<String> subdivision) {
        this.subdivision = subdivision;
    }

    public void setSubdivision(String subdivision) {
        this.subdivision = JsonNullable.of((Object)subdivision);
    }

    public CounterpartyAddressBankModel postalCode(String postalCode) {
        this.postalCode = JsonNullable.of((Object)postalCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal/post/zip code of the address; not used by all countries.")
    @JsonIgnore
    public String getPostalCode() {
        return (String)this.postalCode.orElse(null);
    }

    @JsonProperty(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPostalCode_JsonNullable() {
        return this.postalCode;
    }

    @JsonProperty(value="postal_code")
    public void setPostalCode_JsonNullable(JsonNullable<String> postalCode) {
        this.postalCode = postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = JsonNullable.of((Object)postalCode);
    }

    public CounterpartyAddressBankModel countryCode(String countryCode) {
        this.countryCode = JsonNullable.of((Object)countryCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166 country 2-Alpha country code of the address.")
    @JsonIgnore
    public String getCountryCode() {
        return (String)this.countryCode.orElse(null);
    }

    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCountryCode_JsonNullable() {
        return this.countryCode;
    }

    @JsonProperty(value="country_code")
    public void setCountryCode_JsonNullable(JsonNullable<String> countryCode) {
        this.countryCode = countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = JsonNullable.of((Object)countryCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterpartyAddressBankModel counterpartyAddress = (CounterpartyAddressBankModel)o;
        return CounterpartyAddressBankModel.equalsNullable(this.street, counterpartyAddress.street) && CounterpartyAddressBankModel.equalsNullable(this.street2, counterpartyAddress.street2) && CounterpartyAddressBankModel.equalsNullable(this.city, counterpartyAddress.city) && CounterpartyAddressBankModel.equalsNullable(this.subdivision, counterpartyAddress.subdivision) && CounterpartyAddressBankModel.equalsNullable(this.postalCode, counterpartyAddress.postalCode) && CounterpartyAddressBankModel.equalsNullable(this.countryCode, counterpartyAddress.countryCode);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(CounterpartyAddressBankModel.hashCodeNullable(this.street), CounterpartyAddressBankModel.hashCodeNullable(this.street2), CounterpartyAddressBankModel.hashCodeNullable(this.city), CounterpartyAddressBankModel.hashCodeNullable(this.subdivision), CounterpartyAddressBankModel.hashCodeNullable(this.postalCode), CounterpartyAddressBankModel.hashCodeNullable(this.countryCode));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CounterpartyAddressBankModel {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    subdivision: ").append(this.toIndentedString(this.subdivision)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

