/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.ComplianceDecisionBankModel;
import app.cybrid.cybrid_api_bank.client.model.CounterpartyAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.CounterpartyAliasesInnerBankModel;
import app.cybrid.cybrid_api_bank.client.model.CounterpartyNameBankModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "type", "bank_guid", "customer_guid", "created_at", "updated_at", "state", "name", "address", "aliases", "date_of_birth", "labels", "compliance_decisions"})
@JsonTypeName(value="Counterparty")
public class CounterpartyBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<CounterpartyNameBankModel> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private JsonNullable<CounterpartyAddressBankModel> address = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private JsonNullable<List<CounterpartyAliasesInnerBankModel>> aliases = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private JsonNullable<LocalDate> dateOfBirth = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COMPLIANCE_DECISIONS = "compliance_decisions";
    private List<ComplianceDecisionBankModel> complianceDecisions = null;

    public CounterpartyBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the counterparty.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public CounterpartyBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty type; one of business or individual.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public CounterpartyBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the counterparty's bank.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public CounterpartyBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the counterparty's customer.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public CounterpartyBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public CounterpartyBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public CounterpartyBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty state; one of storing, unverified, verified, or rejected.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public CounterpartyBankModel name(CounterpartyNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public CounterpartyNameBankModel getName() {
        return (CounterpartyNameBankModel)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CounterpartyNameBankModel> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<CounterpartyNameBankModel> name) {
        this.name = name;
    }

    public void setName(CounterpartyNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
    }

    public CounterpartyBankModel address(CounterpartyAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public CounterpartyAddressBankModel getAddress() {
        return (CounterpartyAddressBankModel)this.address.orElse(null);
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CounterpartyAddressBankModel> getAddress_JsonNullable() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress_JsonNullable(JsonNullable<CounterpartyAddressBankModel> address) {
        this.address = address;
    }

    public void setAddress(CounterpartyAddressBankModel address) {
        this.address = JsonNullable.of((Object)address);
    }

    public CounterpartyBankModel aliases(List<CounterpartyAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
        return this;
    }

    public CounterpartyBankModel addAliasesItem(CounterpartyAliasesInnerBankModel aliasesItem) {
        if (this.aliases == null || !this.aliases.isPresent()) {
            this.aliases = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.aliases.get()).add(aliasesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's aliases. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public List<CounterpartyAliasesInnerBankModel> getAliases() {
        return (List)this.aliases.orElse(null);
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<CounterpartyAliasesInnerBankModel>> getAliases_JsonNullable() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    public void setAliases_JsonNullable(JsonNullable<List<CounterpartyAliasesInnerBankModel>> aliases) {
        this.aliases = aliases;
    }

    public void setAliases(List<CounterpartyAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
    }

    public CounterpartyBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's DOB. Only available for GET operations when 'include_pii' is set.")
    @JsonIgnore
    public LocalDate getDateOfBirth() {
        return (LocalDate)this.dateOfBirth.orElse(null);
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getDateOfBirth_JsonNullable() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    public void setDateOfBirth_JsonNullable(JsonNullable<LocalDate> dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
    }

    public CounterpartyBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public CounterpartyBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the counterparty.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public CounterpartyBankModel complianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
        return this;
    }

    public CounterpartyBankModel addComplianceDecisionsItem(ComplianceDecisionBankModel complianceDecisionsItem) {
        if (this.complianceDecisions == null) {
            this.complianceDecisions = new ArrayList<ComplianceDecisionBankModel>();
        }
        this.complianceDecisions.add(complianceDecisionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The compliance decisions associated with the counterparty.")
    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComplianceDecisionBankModel> getComplianceDecisions() {
        return this.complianceDecisions;
    }

    @JsonProperty(value="compliance_decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComplianceDecisions(List<ComplianceDecisionBankModel> complianceDecisions) {
        this.complianceDecisions = complianceDecisions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterpartyBankModel counterparty = (CounterpartyBankModel)o;
        return Objects.equals(this.guid, counterparty.guid) && Objects.equals(this.type, counterparty.type) && Objects.equals(this.bankGuid, counterparty.bankGuid) && CounterpartyBankModel.equalsNullable(this.customerGuid, counterparty.customerGuid) && Objects.equals(this.createdAt, counterparty.createdAt) && Objects.equals(this.updatedAt, counterparty.updatedAt) && Objects.equals(this.state, counterparty.state) && CounterpartyBankModel.equalsNullable(this.name, counterparty.name) && CounterpartyBankModel.equalsNullable(this.address, counterparty.address) && CounterpartyBankModel.equalsNullable(this.aliases, counterparty.aliases) && CounterpartyBankModel.equalsNullable(this.dateOfBirth, counterparty.dateOfBirth) && CounterpartyBankModel.equalsNullable(this.labels, counterparty.labels) && Objects.equals(this.complianceDecisions, counterparty.complianceDecisions);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.type, this.bankGuid, CounterpartyBankModel.hashCodeNullable(this.customerGuid), this.createdAt, this.updatedAt, this.state, CounterpartyBankModel.hashCodeNullable(this.name), CounterpartyBankModel.hashCodeNullable(this.address), CounterpartyBankModel.hashCodeNullable(this.aliases), CounterpartyBankModel.hashCodeNullable(this.dateOfBirth), CounterpartyBankModel.hashCodeNullable(this.labels), this.complianceDecisions);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CounterpartyBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    complianceDecisions: ").append(this.toIndentedString(this.complianceDecisions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

