/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The hold details if a transfer is or will be placed on a hold.")
@JsonPropertyOrder(value={"applicable_types", "duration", "started_at"})
@JsonTypeName(value="Transfer_hold_details")
public class TransferHoldDetailsBankModel {
    public static final String JSON_PROPERTY_APPLICABLE_TYPES = "applicable_types";
    private JsonNullable<List<String>> applicableTypes = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DURATION = "duration";
    private JsonNullable<BigInteger> duration = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    private JsonNullable<OffsetDateTime> startedAt = JsonNullable.undefined();

    public TransferHoldDetailsBankModel applicableTypes(List<String> applicableTypes) {
        this.applicableTypes = JsonNullable.of(applicableTypes);
        return this;
    }

    public TransferHoldDetailsBankModel addApplicableTypesItem(String applicableTypesItem) {
        if (this.applicableTypes == null || !this.applicableTypes.isPresent()) {
            this.applicableTypes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.applicableTypes.get()).add(applicableTypesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of hold types that are applicable for the transfer; one of administrative or non_administrative.")
    @JsonIgnore
    public List<String> getApplicableTypes() {
        return (List)this.applicableTypes.orElse(null);
    }

    @JsonProperty(value="applicable_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getApplicableTypes_JsonNullable() {
        return this.applicableTypes;
    }

    @JsonProperty(value="applicable_types")
    public void setApplicableTypes_JsonNullable(JsonNullable<List<String>> applicableTypes) {
        this.applicableTypes = applicableTypes;
    }

    public void setApplicableTypes(List<String> applicableTypes) {
        this.applicableTypes = JsonNullable.of(applicableTypes);
    }

    public TransferHoldDetailsBankModel duration(BigInteger duration) {
        this.duration = JsonNullable.of((Object)duration);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The approximate time (in seconds) that the transfer will be held for.")
    @JsonIgnore
    public BigInteger getDuration() {
        return (BigInteger)this.duration.orElse(null);
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getDuration_JsonNullable() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration_JsonNullable(JsonNullable<BigInteger> duration) {
        this.duration = duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = JsonNullable.of((Object)duration);
    }

    public TransferHoldDetailsBankModel startedAt(OffsetDateTime startedAt) {
        this.startedAt = JsonNullable.of((Object)startedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the transfer hold was started at.")
    @JsonIgnore
    public OffsetDateTime getStartedAt() {
        return (OffsetDateTime)this.startedAt.orElse(null);
    }

    @JsonProperty(value="started_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getStartedAt_JsonNullable() {
        return this.startedAt;
    }

    @JsonProperty(value="started_at")
    public void setStartedAt_JsonNullable(JsonNullable<OffsetDateTime> startedAt) {
        this.startedAt = startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = JsonNullable.of((Object)startedAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferHoldDetailsBankModel transferHoldDetails = (TransferHoldDetailsBankModel)o;
        return TransferHoldDetailsBankModel.equalsNullable(this.applicableTypes, transferHoldDetails.applicableTypes) && TransferHoldDetailsBankModel.equalsNullable(this.duration, transferHoldDetails.duration) && TransferHoldDetailsBankModel.equalsNullable(this.startedAt, transferHoldDetails.startedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(TransferHoldDetailsBankModel.hashCodeNullable(this.applicableTypes), TransferHoldDetailsBankModel.hashCodeNullable(this.duration), TransferHoldDetailsBankModel.hashCodeNullable(this.startedAt));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferHoldDetailsBankModel {\n");
        sb.append("    applicableTypes: ").append(this.toIndentedString(this.applicableTypes)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

