/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "name", "asset", "amount", "interval", "activities", "sides"})
@JsonTypeName(value="ActivityLimit")
public class ActivityLimitBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private JsonNullable<BigInteger> interval = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACTIVITIES = "activities";
    private List<String> activities = null;
    public static final String JSON_PROPERTY_SIDES = "sides";
    private List<String> sides = null;

    public ActivityLimitBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the limit; one of rolling, daily, weekly, or monthly.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public ActivityLimitBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the limit.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ActivityLimitBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code for the limit.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public ActivityLimitBankModel amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The limit amount for the asset.")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public ActivityLimitBankModel interval(BigInteger interval) {
        this.interval = JsonNullable.of((Object)interval);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The limit interval in seconds for the asset.")
    @JsonIgnore
    public BigInteger getInterval() {
        return (BigInteger)this.interval.orElse(null);
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getInterval_JsonNullable() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval_JsonNullable(JsonNullable<BigInteger> interval) {
        this.interval = interval;
    }

    public void setInterval(BigInteger interval) {
        this.interval = JsonNullable.of((Object)interval);
    }

    public ActivityLimitBankModel activities(List<String> activities) {
        this.activities = activities;
        return this;
    }

    public ActivityLimitBankModel addActivitiesItem(String activitiesItem) {
        if (this.activities == null) {
            this.activities = new ArrayList<String>();
        }
        this.activities.add(activitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The activities associated with the limit.")
    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getActivities() {
        return this.activities;
    }

    @JsonProperty(value="activities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivities(List<String> activities) {
        this.activities = activities;
    }

    public ActivityLimitBankModel sides(List<String> sides) {
        this.sides = sides;
        return this;
    }

    public ActivityLimitBankModel addSidesItem(String sidesItem) {
        if (this.sides == null) {
            this.sides = new ArrayList<String>();
        }
        this.sides.add(sidesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sides associated with the limit.")
    @JsonProperty(value="sides")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSides() {
        return this.sides;
    }

    @JsonProperty(value="sides")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSides(List<String> sides) {
        this.sides = sides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityLimitBankModel activityLimit = (ActivityLimitBankModel)o;
        return Objects.equals(this.type, activityLimit.type) && Objects.equals(this.name, activityLimit.name) && Objects.equals(this.asset, activityLimit.asset) && Objects.equals(this.amount, activityLimit.amount) && ActivityLimitBankModel.equalsNullable(this.interval, activityLimit.interval) && Objects.equals(this.activities, activityLimit.activities) && Objects.equals(this.sides, activityLimit.sides);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.asset, this.amount, ActivityLimitBankModel.hashCodeNullable(this.interval), this.activities, this.sides);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityLimitBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    sides: ").append(this.toIndentedString(this.sides)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

