/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for workflow creation.")
@JsonPropertyOrder(value={"type", "kind", "customer_guid", "external_bank_account_guid", "language", "link_customization_name", "redirect_uri", "android_package_name"})
@JsonTypeName(value="PostWorkflow")
public class PostWorkflowBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_KIND = "kind";
    private JsonNullable<KindEnum> kind = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private JsonNullable<String> externalBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private JsonNullable<LanguageEnum> language = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINK_CUSTOMIZATION_NAME = "link_customization_name";
    private JsonNullable<String> linkCustomizationName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REDIRECT_URI = "redirect_uri";
    private JsonNullable<String> redirectUri = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ANDROID_PACKAGE_NAME = "android_package_name";
    private JsonNullable<String> androidPackageName = JsonNullable.undefined();

    public PostWorkflowBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The workflow type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostWorkflowBankModel kind(KindEnum kind) {
        this.kind = JsonNullable.of((Object)((Object)kind));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid workflow kind. Required when type is plaid.")
    @JsonIgnore
    public KindEnum getKind() {
        return (KindEnum)((Object)this.kind.orElse(null));
    }

    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<KindEnum> getKind_JsonNullable() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind_JsonNullable(JsonNullable<KindEnum> kind) {
        this.kind = kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = JsonNullable.of((Object)((Object)kind));
    }

    public PostWorkflowBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier associated with the workflow. Optional when type is plaid and kind is link_token_create.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostWorkflowBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The external bank account identifier associated with the workflow. Required when type is plaid and kind is link_token_update.")
    @JsonIgnore
    public String getExternalBankAccountGuid() {
        return (String)this.externalBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalBankAccountGuid_JsonNullable() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    public void setExternalBankAccountGuid_JsonNullable(JsonNullable<String> externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
    }

    public PostWorkflowBankModel language(LanguageEnum language) {
        this.language = JsonNullable.of((Object)((Object)language));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The language to initialize Plaid link. Required when type is plaid.")
    @JsonIgnore
    public LanguageEnum getLanguage() {
        return (LanguageEnum)((Object)this.language.orElse(null));
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LanguageEnum> getLanguage_JsonNullable() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage_JsonNullable(JsonNullable<LanguageEnum> language) {
        this.language = language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = JsonNullable.of((Object)((Object)language));
    }

    public PostWorkflowBankModel linkCustomizationName(String linkCustomizationName) {
        this.linkCustomizationName = JsonNullable.of((Object)linkCustomizationName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customization name for Plaid link. For English, use \"default\". For Spanish, use \"spanish_customization\". Required when type is plaid.")
    @JsonIgnore
    public String getLinkCustomizationName() {
        return (String)this.linkCustomizationName.orElse(null);
    }

    @JsonProperty(value="link_customization_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLinkCustomizationName_JsonNullable() {
        return this.linkCustomizationName;
    }

    @JsonProperty(value="link_customization_name")
    public void setLinkCustomizationName_JsonNullable(JsonNullable<String> linkCustomizationName) {
        this.linkCustomizationName = linkCustomizationName;
    }

    public void setLinkCustomizationName(String linkCustomizationName) {
        this.linkCustomizationName = JsonNullable.of((Object)linkCustomizationName);
    }

    public PostWorkflowBankModel redirectUri(String redirectUri) {
        this.redirectUri = JsonNullable.of((Object)redirectUri);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The redirect URI for Plaid link. Optional when type is plaid.")
    @JsonIgnore
    public String getRedirectUri() {
        return (String)this.redirectUri.orElse(null);
    }

    @JsonProperty(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRedirectUri_JsonNullable() {
        return this.redirectUri;
    }

    @JsonProperty(value="redirect_uri")
    public void setRedirectUri_JsonNullable(JsonNullable<String> redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = JsonNullable.of((Object)redirectUri);
    }

    public PostWorkflowBankModel androidPackageName(String androidPackageName) {
        this.androidPackageName = JsonNullable.of((Object)androidPackageName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Android package name for Plaid link. Optional when type is plaid.")
    @JsonIgnore
    public String getAndroidPackageName() {
        return (String)this.androidPackageName.orElse(null);
    }

    @JsonProperty(value="android_package_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAndroidPackageName_JsonNullable() {
        return this.androidPackageName;
    }

    @JsonProperty(value="android_package_name")
    public void setAndroidPackageName_JsonNullable(JsonNullable<String> androidPackageName) {
        this.androidPackageName = androidPackageName;
    }

    public void setAndroidPackageName(String androidPackageName) {
        this.androidPackageName = JsonNullable.of((Object)androidPackageName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostWorkflowBankModel postWorkflow = (PostWorkflowBankModel)o;
        return Objects.equals((Object)this.type, (Object)postWorkflow.type) && PostWorkflowBankModel.equalsNullable(this.kind, postWorkflow.kind) && PostWorkflowBankModel.equalsNullable(this.customerGuid, postWorkflow.customerGuid) && PostWorkflowBankModel.equalsNullable(this.externalBankAccountGuid, postWorkflow.externalBankAccountGuid) && PostWorkflowBankModel.equalsNullable(this.language, postWorkflow.language) && PostWorkflowBankModel.equalsNullable(this.linkCustomizationName, postWorkflow.linkCustomizationName) && PostWorkflowBankModel.equalsNullable(this.redirectUri, postWorkflow.redirectUri) && PostWorkflowBankModel.equalsNullable(this.androidPackageName, postWorkflow.androidPackageName);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, PostWorkflowBankModel.hashCodeNullable(this.kind), PostWorkflowBankModel.hashCodeNullable(this.customerGuid), PostWorkflowBankModel.hashCodeNullable(this.externalBankAccountGuid), PostWorkflowBankModel.hashCodeNullable(this.language), PostWorkflowBankModel.hashCodeNullable(this.linkCustomizationName), PostWorkflowBankModel.hashCodeNullable(this.redirectUri), PostWorkflowBankModel.hashCodeNullable(this.androidPackageName)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostWorkflowBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    linkCustomizationName: ").append(this.toIndentedString(this.linkCustomizationName)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    androidPackageName: ").append(this.toIndentedString(this.androidPackageName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LanguageEnum {
        EN("en"),
        FR("fr"),
        ES("es"),
        NL("nl"),
        DE("de");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum KindEnum {
        CREATE("link_token_create"),
        UPDATE("link_token_update");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        PLAID("plaid");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

